/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePatchCommand
extends BazaarCommand {
    private final List<IBzrLocalResource> resources;
    private final IBazaarRevisionSpec revision;
    private final Option[] options;
    private String patchContent;

    public CreatePatchCommand(List<IBzrLocalResource> resources, IBazaarRevisionSpec revision, Option[] options) {
        this.resources = resources;
        this.revision = revision;
        this.options = options;
    }

    @Override
    public void run(IProgressMonitor monitor) throws BazaarException {
        monitor.beginTask(CoreTexts.DiffCommand_diff, 100);
        try {
            try {
                List<File> files = CreatePatchCommand.getFiles(this.resources);
                IBazaarClient client = CreatePatchCommand.getClient(this.resources.get(0).getIResource().getProject());
                this.patchContent = client.diff(files.toArray(new File[0]), this.revision, this.getOptions());
                monitor.worked(100);
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public String getPatchContent() {
        return this.patchContent;
    }
}

