/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.commands.ResourceChangeCommand;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreCommand
extends ResourceChangeCommand {
    private final List<? extends IResource> resources;
    private final BzrWorkspaceRoot root;

    public IgnoreCommand(BzrWorkspaceRoot bzrWorkspaceRoot, List<? extends IResource> resources) {
        this.root = bzrWorkspaceRoot;
        this.resources = resources;
    }

    @Override
    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        try {
            File rootfile = this.root.getBranch().getFile();
            for (IResource iResource : this.resources) {
                IBzrLocalResource bzrResource = BzrWorkspaceRoot.getBzrResourceFor(iResource);
                this.root.getClient().ignore(rootfile, bzrResource.getBranchRelativePath().toString());
            }
            return this.resources.toArray(new IResource[0]);
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
    }
}

