/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoredCommand
extends BazaarCommand {
    private final IResource resource;
    private final Map<IResource, String> ignored = new HashMap<IResource, String>();

    public IgnoredCommand(IResource resource) {
        this.resource = resource;
    }

    @Override
    public void run(IProgressMonitor monitor) throws BazaarException {
        IProgressMonitor subMonitor = EclipseBazaarCore.subProgressMonitorFor(monitor);
        try {
            try {
                subMonitor.beginTask("executing ignored", 10);
                IBazaarClient client = IgnoredCommand.getClient(this.resource.getProject());
                Map ignored = client.ignored(this.resource.getLocation().toFile());
                for (Map.Entry entry : ignored.entrySet()) {
                    IProject project = this.resource.getProject();
                    Path fullIgnoredPath = new Path((String)entry.getKey());
                    IPath ignoredPath = fullIgnoredPath.removeFirstSegments(fullIgnoredPath.matchingFirstSegments(project.getLocation()));
                    IResource resource = project.findMember(ignoredPath);
                    this.ignored.put(resource, (String)entry.getValue());
                }
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e, this.resource);
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public Map<IResource, String> getIgnored() {
        return this.ignored;
    }
}

