/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.client.commandline.syntax.IInfoOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class InfoCommand
extends BazaarCommand {
    private IBzrBranch branch;
    private IBazaarInfo info;
    private boolean verbose;

    public InfoCommand(IBzrBranch branch) {
        this.branch = branch;
        this.verbose = true;
    }

    public InfoCommand(IBzrBranch branch, boolean verbose) {
        this.branch = branch;
        this.verbose = verbose;
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            try {
                monitor.beginTask("Info command", 10000);
                IBazaarClient client = InfoCommand.getClient(this.branch, true);
                if (this.verbose) {
                    this.addOptions(IInfoOptions.VERBOSE);
                }
                this.info = client.info(this.branch.getFile(), this.getOptions());
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public IBazaarInfo getInfo() {
        return this.info;
    }
}

