/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class InitCommand
extends BazaarCommand {
    private final IProject project;
    private final IPath branchPath;

    public InitCommand(IPath bzrPath, IProject project) {
        this.project = project;
        this.branchPath = bzrPath;
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            IBazaarClient client = EclipseBazaarCore.getDefault().createClient();
            client.setWorkDir(this.branchPath.toFile().getParentFile());
            if (this.project != null && !new File(this.branchPath.toFile(), ".bzr").exists()) {
                client.init(this.branchPath.toFile(), this.getOptions());
            }
        }
        catch (BazaarClientException e) {
            EclipseBazaarCore.log(e.getMessage(), 4);
            throw BazaarException.wrapException(e, (IResource)this.project);
        }
    }
}

