/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.ILogOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrResource;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogCommand
extends BazaarCommand {
    private IBzrResource resource;
    private List<IBazaarLogMessage> logMessages;
    private Integer limit;
    private IBazaarRevisionSpec revision;
    private boolean verbose;

    public LogCommand(IBzrResource bzrResource, IBazaarRevisionSpec revision, boolean verbose) {
        this.resource = bzrResource;
        this.revision = revision;
        this.verbose = verbose;
    }

    public LogCommand(IBzrResource bzrResource, IBazaarRevisionSpec revision, Integer limit) {
        this.resource = bzrResource;
        this.revision = revision;
        this.limit = limit;
    }

    @Override
    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            if (this.resource == null) {
                return;
            }
            try {
                monitor.beginTask(CoreTexts.LogCommand_log, 1000);
                monitor.setTaskName(CoreTexts.LogCommand_log);
                IBazaarClient client = LogCommand.getClient(this.resource.getBranch(), false);
                if (this.limit != null) {
                    this.addOptions(new Option[]{ILogOptions.LIMIT.setArgument(this.limit.toString())});
                }
                if (this.revision != null) {
                    this.addOptions(new Option[]{ILogOptions.REVISION.setArgument(this.revision.toString())});
                }
                if (this.verbose) {
                    this.addOptions(ILogOptions.VERBOSE);
                }
                if (this.resource instanceof IBzrBranch) {
                    this.logMessages = client.log(((IBzrBranch)this.resource).getBranchLocation(), this.getOptions());
                } else if (this.resource instanceof IBzrLocalResource) {
                    IBzrLocalResource localResource = (IBzrLocalResource)this.resource;
                    this.logMessages = client.log(localResource.getFile(), this.getOptions());
                } else {
                    this.logMessages = client.log(this.resource.getLocation(), this.getOptions());
                }
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public List<IBazaarLogMessage> getLogMessages() {
        if (this.logMessages == null) {
            this.logMessages = Collections.emptyList();
        }
        return this.logMessages;
    }
}

