/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarItemInfo;
import org.vcs.bazaar.client.commandline.syntax.ILsOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class LsCommand
extends BazaarCommand {
    private IResource resource;
    private boolean ignored;
    private IBazaarItemInfo[] paths;

    public LsCommand(IResource resource, boolean ignored) {
        this.resource = resource;
        this.ignored = ignored;
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            try {
                monitor.beginTask("executing ls", 1000);
                IBazaarClient client = LsCommand.getClient(this.resource.getProject(), true);
                if (this.ignored) {
                    this.addOptions(ILsOptions.IGNORED);
                }
                this.addOptions(ILsOptions.VERSIONED);
                this.paths = client.ls(this.resource.getLocation().toFile(), null, this.getOptions());
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e, this.resource);
            }
        }
        finally {
            monitor.done();
        }
    }

    public IBazaarItemInfo[] getPaths() {
        return this.paths;
    }
}

