/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IMergeOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.MetaModifyCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class MergeCommand
extends MetaModifyCommand {
    private final IBzrBranch branch;
    private final BranchLocation location;

    public MergeCommand(IBzrBranch branch, BranchLocation location, Option ... options) {
        this.branch = branch;
        this.location = location;
        this.addOptions(options);
    }

    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        block6: {
            try {
                try {
                    monitor.beginTask(CoreTexts.MergeCommand_taskName, 100);
                    monitor.setTaskName(CoreTexts.MergeCommand_taskName);
                    IBazaarClient client = MergeCommand.getClient(this.branch);
                    monitor.worked(10);
                    client.merge(this.location, this.getOptions());
                }
                catch (BazaarClientException e) {
                    if (!this.setPostCommandErrorOnConflicts(e.getMessage())) {
                        throw BazaarException.wrapException(e);
                    }
                    monitor.done();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        return BzrWorkspaceRoot.findProjectsInBranch(this.branch);
    }

    protected int getChangeType() {
        Option[] optionArray = this.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (option.equals((Object)IMergeOptions.PULL)) {
                return 16;
            }
            ++n2;
        }
        return 4;
    }
}

