/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaModifyCommand
extends BazaarCommand {
    protected static final Pattern CONFLICT_PATTERN = Pattern.compile("conflict.*encountered");
    protected static final Pattern CONFLICT_LINE_PATTERN = Pattern.compile(".*conflict.*", 2);
    protected BazaarException postCommandError;

    protected boolean isTouchRequired() {
        return false;
    }

    @Override
    public void run(IProgressMonitor monitor) throws BazaarException {
        monitor.beginTask("", 100);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 90);
        final IResource[] resources = this.execute((IProgressMonitor)subMonitor);
        subMonitor = new SubProgressMonitor(monitor, 10);
        try {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            monitor.beginTask("", resources.length);
                            monitor.setTaskName(CoreTexts.MetaModifyCommad_refreshing);
                            IResource[] iResourceArray = resources;
                            int n = resources.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResource resource = iResourceArray[n2];
                                if (resource.exists()) {
                                    if (monitor.isCanceled()) {
                                        break;
                                    }
                                    if (MetaModifyCommand.this.isTouchRequired() && resource.isSynchronized(2)) {
                                        resource.touch((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    } else {
                                        resource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    }
                                    ResourceUtil.markAsDirty(resource);
                                }
                                monitor.worked(1);
                                ++n2;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }, (IProgressMonitor)subMonitor);
                List<IResource> resourceToRefresh = Arrays.asList(resources);
                EclipseBazaarCore.getDefault().getStatusCacheManager().scheduleRefresh(resourceToRefresh, (IProgressMonitor)new NullProgressMonitor(), this.getChangeType());
            }
            catch (CoreException e) {
                throw BazaarException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
        if (this.getPostCommandError() != null) {
            throw this.getPostCommandError();
        }
    }

    public abstract IResource[] execute(IProgressMonitor var1) throws BazaarException;

    protected abstract int getChangeType();

    protected BazaarException getPostCommandError() {
        return this.postCommandError;
    }

    protected static IResource[] getIResources(IBzrLocalResource[] bzrResources) {
        ArrayList<IResource> resources = new ArrayList<IResource>(bzrResources.length);
        IBzrLocalResource[] iBzrLocalResourceArray = bzrResources;
        int n = bzrResources.length;
        int n2 = 0;
        while (n2 < n) {
            IBzrLocalResource resource = iBzrLocalResourceArray[n2];
            resources.add(resource.getIResource());
            ++n2;
        }
        return resources.toArray(new IResource[0]);
    }

    protected static IResource[] getIResources(List<IBzrLocalResource> bzrResources) {
        return MetaModifyCommand.getIResources(bzrResources.toArray(new IBzrLocalResource[0]));
    }

    protected boolean setPostCommandErrorOnConflicts(String message) {
        if (message != null && CONFLICT_PATTERN.matcher(message).find()) {
            Matcher m = CONFLICT_LINE_PATTERN.matcher(message);
            StringBuilder sb = new StringBuilder();
            while (m.find()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(m.group());
            }
            this.postCommandError = new BazaarException(1, 0, sb.toString());
            return true;
        }
        return false;
    }
}

