/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class NickCommand
extends BazaarCommand {
    private IBzrBranch branch;
    private String nick;

    public NickCommand(IBzrBranch branch) {
        this.branch = branch;
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            try {
                monitor.beginTask(CoreTexts.NickCommand_nick, 1000);
                IBazaarClient client = NickCommand.getClient(this.branch, true);
                monitor.worked(500);
                this.nick = client.nick(null);
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public String getNick() {
        return this.nick.split(System.getProperty("line.separator"))[0];
    }
}

