/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarProgressListener;
import org.vcs.bazaar.client.commandline.syntax.IPullOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.CommandProgressListener;
import org.vcs.bazaar.eclipse.core.commands.StateChangeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class PullCommand
extends StateChangeCommand {
    private IBzrBranch branch;
    private BranchLocation location;
    private boolean remember;
    private boolean overwrite;

    public PullCommand(IBzrBranch branch, BranchLocation location) {
        this.branch = branch;
        this.location = location;
    }

    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        try {
            monitor.beginTask(CoreTexts.PullCommand_taskName, 100);
            IBazaarClient client = PullCommand.getClient(this.branch);
            if (this.remember) {
                this.addOptions(IPullOptions.REMEMBER);
            }
            if (this.overwrite) {
                this.addOptions(IPullOptions.OVERWRITE);
            }
            String err = client.pull(this.location, (IBazaarProgressListener)new CommandProgressListener(monitor), this.getOptions());
            this.setPostCommandErrorOnConflicts(err);
            IProject[] iProjectArray = BzrWorkspaceRoot.findProjectsInBranch(this.branch);
            return iProjectArray;
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        finally {
            monitor.done();
        }
    }

    public void setRemember(boolean remember) {
        this.remember = remember;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

