/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.syntax.IPushOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class PushCommand
extends BazaarCommand {
    private IBzrBranch branch;
    private BranchLocation location;
    private boolean remember;
    private boolean overwrite;
    private boolean useExsitingDir;

    public PushCommand(IBzrBranch branch, BranchLocation location) {
        this.branch = branch;
        this.location = location;
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            try {
                IBazaarClient client = PushCommand.getClient(this.branch);
                if (this.remember) {
                    this.addOptions(IPushOptions.REMEMBER);
                }
                if (this.useExsitingDir) {
                    this.addOptions(IPushOptions.USE_EXISTING_DIR);
                }
                if (this.overwrite) {
                    this.addOptions(IPushOptions.OVERWRITE);
                }
                client.push(this.location, this.getOptions());
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void setRemember(boolean remember) {
        this.remember = remember;
    }

    public void setUseExsitingDir(boolean useExsitingDir) {
        this.useExsitingDir = useExsitingDir;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

