/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.StateChangeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class RebaseCommand
extends StateChangeCommand {
    private final IBzrBranch branch;
    private final BranchLocation location;
    private BazaarException rebaseConflictsException;
    private static final Pattern CONFLICT_PATTERN = Pattern.compile("conflict occurred");

    protected RebaseCommand(IBzrBranch branch) {
        this(branch, null, new Option[0]);
    }

    public RebaseCommand(IBzrBranch branch, BranchLocation location, Option ... options) {
        this.branch = branch;
        this.location = location;
        this.addOptions(options);
    }

    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        block6: {
            try {
                try {
                    monitor.beginTask(CoreTexts.RebaseCommand_taskName, 100);
                    IBazaarClient client = RebaseCommand.getClient(this.branch);
                    monitor.worked(10);
                    this.executeInternally(client);
                }
                catch (BazaarClientException e) {
                    if (e.getMessage() == null || !CONFLICT_PATTERN.matcher(e.getMessage()).find()) {
                        throw BazaarException.wrapException(e);
                    }
                    this.rebaseConflictsException = new BazaarException(1, 0, CoreTexts.RebaseConflicts_error, e);
                    monitor.done();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        return BzrWorkspaceRoot.findProjectsInBranch(this.branch);
    }

    protected void executeInternally(IBazaarClient client) throws BazaarClientException {
        client.rebase(this.location, this.getOptions());
    }

    protected BazaarException getPostCommandError() {
        return this.rebaseConflictsException;
    }
}

