/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarProgressListener;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.commands.CommandProgressListener;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class ReconfigureCommand
extends BazaarCommand {
    private final IBzrBranch branch;

    public ReconfigureCommand(IBzrBranch branch) {
        this.branch = branch;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BranchLocation getBranchLocation() {
        File metaFolder;
        File branchFolder;
        File locationFile;
        IPath location = this.branch.getPath();
        if (location == null || !(locationFile = new File(branchFolder = new File(metaFolder = new File(location.toFile(), ".bzr"), "branch"), "location")).exists()) return null;
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(locationFile));
        BranchLocation branchLocation = new BranchLocation(reader.readLine());
        if (reader == null) return branchLocation;
        try {
            reader.close();
            return branchLocation;
        }
        catch (IOException iOException) {}
        return branchLocation;
        catch (Exception exception) {
            try {
                if (reader == null) return null;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            monitor.beginTask(CoreTexts.bind((String)CoreTexts.Reconfiguring_taskName, (Object)this.branch.getBranchLocation().toString()), 100);
            IBazaarClient client = ReconfigureCommand.getClient(this.branch, false);
            File tempFolder = ResourceUtil.createTempFile("bzreclipse", null);
            tempFolder.delete();
            BranchLocation remoteLocation = this.getBranchLocation();
            if (remoteLocation != null) {
                client.checkout(remoteLocation, tempFolder, (IBazaarProgressListener)new CommandProgressListener(monitor), this.getOptions());
                this.moveFolder(tempFolder, "repository");
                this.moveFolder(tempFolder, "branch");
                ResourceUtil.deleteRecursively(tempFolder);
            }
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        catch (IOException e) {
            throw BazaarException.wrapException(e);
        }
    }

    private void moveFolder(File tempFolder, String folder) throws IOException {
        File srcRepository = new File(String.valueOf(tempFolder.getAbsolutePath()) + File.separator + ".bzr" + File.separator + folder);
        File destRepository = this.branch.getPath().append(".bzr").append(folder).toFile();
        ResourceUtil.deleteRecursively(destRepository);
        ResourceUtil.move(srcRepository, destRepository);
    }
}

