/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.syntax.IRemoveOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.ResourceChangeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class RemoveCommand
extends ResourceChangeCommand {
    private IBzrLocalResource[] resources;

    public RemoveCommand(IBzrLocalResource[] bzrResources) {
        this.resources = bzrResources;
    }

    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        Map<IBzrBranch, List<File>> map = RemoveCommand.getFilesByBranchMap(this.resources);
        try {
            monitor.beginTask(CoreTexts.RemoveCommand_removing, this.resources.length);
            monitor.setTaskName(CoreTexts.RemoveCommand_removing);
            for (IBzrBranch branch : map.keySet()) {
                IBazaarClient client = RemoveCommand.getClient(branch);
                this.addOptions(IRemoveOptions.KEEP);
                client.remove(map.get(branch).toArray(new File[0]), this.getOptions());
            }
            IResource[] iResourceArray = RemoveCommand.getIResources(this.resources);
            return iResourceArray;
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        finally {
            monitor.done();
        }
    }
}

