/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.commands.ResourceChangeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveCommand
extends ResourceChangeCommand {
    private final IBzrLocalResource[] resources;

    public ResolveCommand(Collection<IResource> resources) {
        this(BzrWorkspaceRoot.getBzrResourcesFor(resources.toArray(new IResource[0])), new Option[0]);
    }

    public ResolveCommand(IBzrLocalResource[] bzrResources, Option ... options) {
        this.resources = bzrResources;
        this.addOptions(options);
    }

    public ResolveCommand(Collection<IResource> resources, Option ... options) {
        this(BzrWorkspaceRoot.getBzrResourcesFor(resources.toArray(new IResource[0])), options);
    }

    @Override
    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        try {
            if (this.resources != null) {
                IResource[] iResourceArray = this.resolveResources(monitor);
                return iResourceArray;
            }
            IResource[] iResourceArray = new IResource[]{};
            return iResourceArray;
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        finally {
            monitor.done();
        }
    }

    private IResource[] resolveResources(IProgressMonitor monitor) throws BazaarException, BazaarClientException {
        Map<IBzrBranch, List<File>> map = ResolveCommand.getFilesByBranchMap(this.resources);
        monitor.beginTask("Resolving", map.keySet().size());
        for (IBzrBranch branch : map.keySet()) {
            IBazaarClient client = ResolveCommand.getClient(branch);
            client.resolve(map.get(branch), this.getOptions());
            monitor.worked(1);
        }
        ArrayList<IResource> changed = new ArrayList<IResource>(this.resources.length);
        IResource[] iResourceArray = ResolveCommand.getIResources(this.resources);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            changed.add(resource);
            ++n2;
        }
        return changed.toArray(new IResource[changed.size()]);
    }

    @Override
    protected boolean isTouchRequired() {
        return true;
    }
}

