/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class RevnoCommand
extends BazaarCommand {
    private IResource resource;
    private BazaarRevision revision;

    public RevnoCommand(IResource resource) {
        this.resource = resource;
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            try {
                monitor.beginTask(CoreTexts.RevnoCommand_taskName, 1000);
                IBazaarClient client = RevnoCommand.getClient(this.resource.getProject(), true);
                this.revision = client.revno(this.resource.getLocation().toFile());
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e, this.resource);
            }
        }
        finally {
            monitor.done();
        }
    }

    public BazaarRevision getRevision() {
        return this.revision;
    }
}

