/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarAnnotation;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class SendCommand
extends BazaarCommand {
    private final IBzrLocalResource resource;
    private IBazaarAnnotation annotation;
    private BranchLocation branchLocation;

    public SendCommand(IBzrLocalResource bzrResource, Option[] options, BranchLocation branchLocation) {
        this.resource = bzrResource;
        this.addOptions(options);
        this.branchLocation = branchLocation;
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            try {
                monitor.beginTask(CoreTexts.SendCommand_send, 1000);
                IBazaarClient client = SendCommand.getClient(this.resource.getBranch());
                client.send(this.branchLocation, this.getOptions());
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e, this.resource.getIResource());
            }
        }
        finally {
            monitor.done();
        }
    }

    public IBazaarAnnotation getAnnotation() {
        return this.annotation;
    }
}

