/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.ResourceChangeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShelveCommand
extends ResourceChangeCommand {
    private List<IBzrLocalResource> resources;
    private boolean shelveBranch;

    public ShelveCommand(List<IBzrLocalResource> resourcesToShelve, boolean shelveBranch, Option[] options) {
        this.resources = resourcesToShelve;
        this.shelveBranch = shelveBranch;
        this.addOptions(options);
    }

    @Override
    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        Map<IBzrBranch, List<File>> map = ShelveCommand.getFilesByBranchMap(this.resources);
        try {
            monitor.beginTask(CoreTexts.ShelveCommand_taskName, this.resources.size());
            ArrayList<IProject> resourcesToRefresh = new ArrayList<IProject>(this.resources.size());
            for (IBzrBranch branch : map.keySet()) {
                IBazaarClient client = BzrWorkspaceRoot.getClient(branch);
                if (this.shelveBranch) {
                    client.shelve(new File[0], this.getOptions());
                } else {
                    client.shelve(map.get(branch).toArray(new File[0]), this.getOptions());
                }
                resourcesToRefresh.addAll(Arrays.asList(BzrWorkspaceRoot.findProjectsInBranch(branch)));
            }
            monitor.worked(this.resources.size());
            IResource[] iResourceArray = resourcesToRefresh.toArray(new IResource[0]);
            return iResourceArray;
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        finally {
            monitor.done();
        }
    }
}

