/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarShelf;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShelveListCommand
extends BazaarCommand {
    private IBzrBranch branch;
    private List<IBazaarShelf> shelves;

    public ShelveListCommand(IBzrBranch branch) {
        this.branch = branch;
    }

    @Override
    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            try {
                monitor.beginTask(CoreTexts.ShelveListCommand_taskName, 100);
                IBazaarClient client = ShelveListCommand.getClient(this.branch, true);
                this.shelves = client.shelveList(this.getOptions());
                monitor.worked(100);
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public List<IBazaarShelf> getShelves() {
        return this.shelves;
    }
}

