/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.BazaarStatus;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.BazaarTreeStatus;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.commandline.commands.options.KeywordOption;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IStatusOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.internal.core.model.BzrResourceStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCommand
extends BazaarCommand {
    private final IBzrLocalResource[] resources;
    private Map<IResource, IBzrResourceStatus> statusMap;
    private boolean noLog = false;
    private boolean addNestedUnknown = true;
    private List<IBazaarLogMessage> pendingMerges;

    public StatusCommand(IBzrLocalResource[] resources) {
        this(resources, false);
        this.addNestedUnknown = false;
    }

    public StatusCommand(IBzrLocalResource[] resources, boolean noLog) {
        this.resources = resources;
        this.noLog = noLog;
    }

    public StatusCommand(IBzrLocalResource[] resources, IBazaarRevisionSpec revision) {
        this(resources, true);
        this.addOptions(new Option[]{new KeywordOption(IStatusOptions.REVISION.getOption(), revision.toString())});
    }

    @Override
    public void run(IProgressMonitor monitor) throws BazaarException {
        IProgressMonitor subMonitor = EclipseBazaarCore.subProgressMonitorFor(monitor);
        try {
            try {
                this.statusMap = new HashMap<IResource, IBzrResourceStatus>(0);
                this.pendingMerges = new ArrayList<IBazaarLogMessage>();
                Map<IBzrBranch, List<File>> map = StatusCommand.getFilesByBranchMap(this.resources);
                for (IBzrBranch branch : map.keySet()) {
                    if (subMonitor.isCanceled()) continue;
                    this.executeAndFilterLogOutput(branch, map.get(branch).toArray(new File[0]));
                }
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e);
            }
            catch (BazaarException e) {
                throw e;
            }
            catch (CoreException e) {
                throw BazaarException.wrapException(e);
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public IBzrResourceStatus[] getStatus() {
        ArrayList list = new ArrayList(this.statusMap.values().size());
        Collections.addAll(list, this.statusMap.values().toArray(new IBzrResourceStatus[0]));
        return list.toArray(new IBzrResourceStatus[0]);
    }

    public List<IBazaarLogMessage> getPendingMerges() {
        return this.pendingMerges;
    }

    private void executeAndFilterLogOutput(final IBzrBranch branch, File[] files) throws BazaarClientException, CoreException {
        IBazaarClient client = StatusCommand.getClient(branch, this.noLog);
        BazaarTreeStatus treeStatus = client.status(files, this.getOptions());
        this.pendingMerges = treeStatus.getPendingMerges();
        IBazaarStatus[] statuses = treeStatus.getStatusAsArray();
        HashSet<IContainer> unknown = new HashSet<IContainer>();
        IBazaarStatus[] iBazaarStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IBazaarStatus aStatus = iBazaarStatusArray[n2];
            IResource resource = ResourceUtil.getIResource(aStatus);
            if (resource != null) {
                BzrResourceStatus resourceStatus = new BzrResourceStatus(BzrWorkspaceRoot.getBzrResourceFor(resource), aStatus);
                this.statusMap.put(resource, resourceStatus);
                if (this.addNestedUnknown && resourceStatus.isUnknown() && resource instanceof IContainer) {
                    unknown.add((IContainer)resource);
                }
            }
            ++n2;
        }
        for (IContainer folder : unknown) {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (!StatusCommand.this.statusMap.containsKey(resource)) {
                        IPath relPath = resource.getLocation().makeRelativeTo(branch.getPath());
                        IBazaarStatus aStatus = BazaarStatus.create((File)relPath.toFile(), (boolean)(resource instanceof IContainer), (File)branch.getFile(), (BazaarStatusKind[])new BazaarStatusKind[]{BazaarStatusKind.UNKNOWN});
                        BzrResourceStatus resourceStatus = new BzrResourceStatus(BzrWorkspaceRoot.getBzrResourceFor(resource), aStatus);
                        StatusCommand.this.statusMap.put(resource, resourceStatus);
                    }
                    return true;
                }
            }, 2, 4);
        }
    }
}

