/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.BazaarTreeStatus;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarItemInfo;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.ILsOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.BzrStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusUpdaterCommand
extends BazaarCommand {
    private final IBzrLocalResource bzrLocalResource;
    private Map<IResource, BzrStatus> statusMap;
    private Map<IResource, IBazaarLogMessage> logMap;
    private final boolean shallow;
    private final boolean verbose;

    public StatusUpdaterCommand(IBzrLocalResource resource, boolean shallow, boolean verbose) {
        this.bzrLocalResource = resource;
        this.shallow = shallow;
        this.verbose = verbose;
    }

    @Override
    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            this.statusMap = new HashMap<IResource, BzrStatus>();
            this.logMap = new HashMap<IResource, IBazaarLogMessage>();
            IBazaarClient client = StatusUpdaterCommand.getClient(this.bzrLocalResource.getIResource().getProject(), true);
            this.executeAndFilterLogOutput(client);
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e, this.bzrLocalResource.getIResource());
        }
        catch (BazaarException e) {
            throw e;
        }
        catch (CoreException e) {
            throw BazaarException.wrapException(e);
        }
    }

    public Map<IResource, BzrStatus> getStatus() {
        return this.statusMap;
    }

    public Map<IResource, IBazaarLogMessage> getLogMap() {
        return this.logMap;
    }

    private void executeAndFilterLogOutput(IBazaarClient client) throws BazaarClientException, CoreException {
        IBazaarStatus[] statuses;
        HashSet<IResource> versionedSet = new HashSet<IResource>();
        HashSet<IResource> ignoredSet = new HashSet<IResource>();
        HashSet<IResource> unknownSet = new HashSet<IResource>();
        IResource resourceToRefresh = this.bzrLocalResource.getIResource();
        File file = resourceToRefresh.getLocation().toFile();
        this.addOptions(ILsOptions.IGNORED, ILsOptions.VERSIONED, ILsOptions.UNKNOWN);
        if (this.shallow) {
            this.addOptions(ILsOptions.NON_RECURSIVE);
        }
        if (this.verbose) {
            this.addOptions(ILsOptions.VERBOSE);
        }
        IBazaarItemInfo[] paths = client.ls(file, null, this.getOptions());
        BazaarTreeStatus treeStatus = client.status(new File[]{file}, new Option[0]);
        IBazaarStatus[] iBazaarStatusArray = statuses = treeStatus.getStatusAsArray();
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IBazaarStatus aStatus = iBazaarStatusArray[n2];
            IResource resource = ResourceUtil.getIResource(aStatus);
            if (resource != null && ResourceUtil.shouldHandle(resource, false)) {
                BzrStatus resourceStatus = new BzrStatus(aStatus);
                this.statusMap.put(resource, resourceStatus);
                if (resourceStatus.isUnknown() && resource instanceof IContainer) {
                    unknownSet.add(resource);
                }
            }
            ++n2;
        }
        if (paths != null) {
            iBazaarStatusArray = paths;
            n = paths.length;
            n2 = 0;
            while (n2 < n) {
                IBazaarStatus itemInfo = iBazaarStatusArray[n2];
                Path path = new Path(itemInfo.getPath());
                int matchingSegments = resourceToRefresh.getProject().getLocation().matchingFirstSegments((IPath)path);
                IResource resource = resourceToRefresh.getProject().findMember(path.removeFirstSegments(matchingSegments));
                if (resource != null && ResourceUtil.shouldHandle(resource, false)) {
                    if (itemInfo.getLog() != null) {
                        this.logMap.put(resource, itemInfo.getLog());
                    }
                    if (itemInfo.getStatusKind() == BazaarStatusKind.IGNORED) {
                        ignoredSet.add(resource);
                    } else if (itemInfo.getStatusKind() == BazaarStatusKind.UNKNOWN) {
                        if (!this.statusMap.containsKey(resource)) {
                            ignoredSet.add(resource);
                        } else {
                            unknownSet.add(resource);
                        }
                    } else {
                        versionedSet.add(resource);
                    }
                }
                ++n2;
            }
            if (resourceToRefresh.getType() == 4 && !versionedSet.contains(resourceToRefresh)) {
                versionedSet.add(resourceToRefresh);
            }
        }
        for (IResource ignored : ignoredSet) {
            ignored.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (!StatusUpdaterCommand.this.statusMap.containsKey(resource)) {
                        StatusUpdaterCommand.this.statusMap.put(resource, BzrStatus.ignored());
                    }
                    return true;
                }
            }, 2, 4);
        }
        for (IResource unknown : unknownSet) {
            unknown.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (!StatusUpdaterCommand.this.statusMap.containsKey(resource)) {
                        StatusUpdaterCommand.this.statusMap.put(resource, BzrStatus.unknown());
                    }
                    return true;
                }
            }, 2, 4);
        }
        for (IResource versioned : versionedSet) {
            if (this.statusMap.containsKey(versioned)) continue;
            this.statusMap.put(versioned, BzrStatus.unchanged());
        }
    }
}

