/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarProgressListener;
import org.vcs.bazaar.client.commandline.syntax.ISwitchOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.CommandProgressListener;
import org.vcs.bazaar.eclipse.core.commands.StateChangeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class SwitchCommand
extends StateChangeCommand {
    private IBzrBranch branch;
    private BranchLocation location;
    private boolean force;
    private boolean createBranch;

    public SwitchCommand(IBzrBranch branch, BranchLocation location) {
        this.branch = branch;
        this.location = location;
    }

    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        try {
            monitor.beginTask(CoreTexts.bind((String)CoreTexts.SwitchCommand_taskName, (Object)this.location.toString()), 100);
            monitor.setTaskName(CoreTexts.bind((String)CoreTexts.SwitchCommand_taskName, (Object)this.location.toString()));
            IBazaarClient client = SwitchCommand.getClient(this.branch);
            if (this.force) {
                this.addOptions(ISwitchOptions.FORCE);
            }
            if (this.createBranch) {
                this.addOptions(ISwitchOptions.CREATE_BRANCH);
            }
            client.switchBranch(this.location, (IBazaarProgressListener)new CommandProgressListener(monitor), this.getOptions());
            IProject[] iProjectArray = BzrWorkspaceRoot.findProjectsInBranch(this.branch);
            return iProjectArray;
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        finally {
            monitor.done();
        }
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setCreateBranch(boolean createBranch) {
        this.createBranch = createBranch;
    }
}

