/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class TagCommand
extends BazaarCommand {
    private final IBzrBranch branch;
    private final String tagName;

    public TagCommand(IBzrBranch branch, String tagName, Option[] options) {
        this.branch = branch;
        this.tagName = tagName;
        this.addOptions(options);
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            try {
                monitor.beginTask(CoreTexts.bind((String)CoreTexts.TagCommand_taskName, (Object)this.branch.getName()), 100);
                monitor.setTaskName(CoreTexts.bind((String)CoreTexts.TagCommand_taskName, (Object)this.branch.getName()));
                IBazaarClient client = TagCommand.getClient(this.branch);
                client.tag(this.tagName, this.getOptions());
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

