/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.ResourceChangeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class UnBindCommand
extends ResourceChangeCommand {
    private IBzrBranch branch;

    public UnBindCommand(IBzrBranch branch) {
        this.branch = branch;
    }

    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        try {
            monitor.beginTask(CoreTexts.UnBindCommand_taskName, 1000);
            monitor.setTaskName(CoreTexts.UnBindCommand_taskName);
            IBazaarClient client = UnBindCommand.getClient(this.branch);
            client.unBind(this.getOptions());
            monitor.worked(1000);
            IProject[] iProjectArray = BzrWorkspaceRoot.findProjectsInBranch(this.branch);
            return iProjectArray;
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        finally {
            monitor.done();
        }
    }
}

