/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.StateChangeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class UnCommitCommand
extends StateChangeCommand {
    private IBzrBranch branch;

    public UnCommitCommand(IBzrBranch branch) {
        this.branch = branch;
    }

    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        try {
            monitor.beginTask(CoreTexts.UnCommitCommand_unCommiting, 100);
            monitor.setTaskName(CoreTexts.UnCommitCommand_unCommiting);
            BzrWorkspaceRoot.getClient(this.branch).unCommit(this.branch.getPath().toFile(), this.getOptions());
            monitor.worked(100);
            IProject[] iProjectArray = BzrWorkspaceRoot.findProjectsInBranch(this.branch);
            return iProjectArray;
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        finally {
            monitor.done();
        }
    }
}

