/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.ResourceChangeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class UnShelveCommand
extends ResourceChangeCommand {
    private IBzrBranch branch;
    private String shelfId;

    public UnShelveCommand(IBzrBranch branch, String shelfId, Option[] options) {
        this.branch = branch;
        this.shelfId = shelfId;
        this.addOptions(options);
    }

    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        try {
            monitor.beginTask(CoreTexts.UnShelveCommand_taskName, 100);
            monitor.setTaskName(CoreTexts.UnShelveCommand_taskName);
            IBazaarClient client = BzrWorkspaceRoot.getClient(this.branch);
            client.unShelve(this.shelfId, this.getOptions());
            monitor.worked(100);
            IProject[] iProjectArray = BzrWorkspaceRoot.findProjectsInBranch(this.branch);
            return iProjectArray;
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        finally {
            monitor.done();
        }
    }
}

