/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.credentials;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.vcs.bazaar.eclipse.core.credentials.BazaarCredentials;
import org.vcs.bazaar.eclipse.core.credentials.SecureCredentialsStoreException;

public class SecureCredentialsStore {
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String BZR_PATH_PREFIX = "/BZR/";
    private static final Pattern PATTERN = Pattern.compile("\\w+://([^@]*)@(.*)");
    private final ISecurePreferences preferences = SecurePreferencesFactory.getDefault();

    private String getPath(String location) {
        return BZR_PATH_PREFIX + EncodingUtils.encodeSlashes((String)location);
    }

    public static String getUserFromLocation(String location) {
        Matcher m = PATTERN.matcher(location);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public BazaarCredentials getCredentials(String location) throws SecureCredentialsStoreException {
        String password;
        String user;
        block5: {
            String pathName;
            block4: {
                try {
                    pathName = this.getPath(location);
                    if (this.preferences.nodeExists(pathName)) break block4;
                    return null;
                }
                catch (Exception e) {
                    throw new SecureCredentialsStoreException(e.getMessage());
                }
            }
            ISecurePreferences node = this.preferences.node(pathName);
            user = node.get(USER, "");
            password = node.get(PASSWORD, "");
            String locationUser = SecureCredentialsStore.getUserFromLocation(location);
            if (locationUser == null || locationUser.equals(user)) break block5;
            return null;
        }
        return new BazaarCredentials(user, password, true);
    }

    public void putCredentials(String location, BazaarCredentials credentials) throws SecureCredentialsStoreException {
        try {
            String pathName = this.getPath(location);
            ISecurePreferences node = this.preferences.node(pathName);
            node.put(USER, credentials.getUser(), false);
            node.put(PASSWORD, credentials.getPassword(), true);
            node.flush();
        }
        catch (Exception e) {
            throw new SecureCredentialsStoreException(e.getMessage());
        }
    }

    public void clearCredentials(String location) throws SecureCredentialsStoreException {
        try {
            String pathName = this.getPath(location);
            if (!this.preferences.nodeExists(pathName)) {
                return;
            }
            ISecurePreferences node = this.preferences.node(pathName);
            node.removeNode();
            node.flush();
        }
        catch (Exception e) {
            throw new SecureCredentialsStoreException(e.getMessage());
        }
    }
}

