/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.history;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.BazaarRevisionRange;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.history.BazaarFileRevision;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarFileHistory
extends FileHistory {
    private IResource resource;
    protected SortedMap<BazaarRevision, BazaarFileRevision> revisionMap = new TreeMap<BazaarRevision, BazaarFileRevision>(new Comparator<BazaarRevision>(){

        @Override
        public int compare(BazaarRevision rev1, BazaarRevision rev2) {
            return rev1.compareTo(rev2);
        }
    });
    protected BazaarRevision lastLoadedRevision;

    protected BazaarFileHistory() {
    }

    public BazaarFileHistory(IResource resource) {
        this();
        this.resource = resource;
    }

    public BazaarFileHistory(List<IBazaarLogMessage> logMessages) {
        this();
        this.addRevisions(logMessages);
    }

    public IFileRevision[] getContributors(IFileRevision revision) {
        BazaarFileRevision bazaarRevision = (BazaarFileRevision)revision;
        List merged = bazaarRevision.getIBazaarLogMessage().getMerged();
        if (merged != null && merged.size() > 0) {
            ArrayList<BazaarFileRevision> revisions = new ArrayList<BazaarFileRevision>(merged.size());
            for (IBazaarLogMessage mergeLog : merged) {
                revisions.add(this.buildRevision(mergeLog));
            }
            return revisions.toArray(new IFileRevision[revisions.size()]);
        }
        return new IFileRevision[]{(IFileRevision)this.revisionMap.get(bazaarRevision.getIBazaarLogMessage().getRevision())};
    }

    public IFileRevision getFileRevision(String id) {
        System.out.println("BazaarFileHistory::getFileRevision(" + id + ")");
        return null;
    }

    public IFileRevision[] getFileRevisions() {
        return this.revisionMap.values().toArray(new IFileRevision[0]);
    }

    public IFileRevision[] getTargets(IFileRevision revision) {
        System.out.println("BazaarFileHistory::getTargets()");
        return null;
    }

    protected List<IBazaarLogMessage> getLogMessages(IBazaarRevisionSpec revision, boolean limit) throws CoreException {
        return EclipseBazaarCore.getDefault().getLogCacheManager().getLogs(this.resource, revision, limit);
    }

    protected boolean isBazaarProvider() {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)this.resource.getProject());
        return provider != null && provider instanceof BazaarTeamProvider;
    }

    public void refresh(IProgressMonitor monitor, boolean limitLogs) throws CoreException {
        if (this.isBazaarProvider()) {
            this.revisionMap.clear();
            this.getLogs(monitor, null, limitLogs);
        }
    }

    public void loadMore(IProgressMonitor monitor) throws CoreException {
        if (this.isBazaarProvider() && this.lastLoadedRevision != null) {
            BazaarRevisionRange range = BazaarRevisionRange.getRange(null, (BazaarRevision)this.lastLoadedRevision);
            this.getLogs(monitor, (IBazaarRevisionSpec)range, true);
        }
    }

    private void getLogs(IProgressMonitor monitor, IBazaarRevisionSpec rev, boolean limitLogs) throws CoreException {
        monitor.subTask("Fetching log messages...");
        List<IBazaarLogMessage> logs = this.getLogMessages(rev, limitLogs);
        monitor.worked(500);
        this.addRevisions(logs);
        monitor.worked(300);
    }

    private void addRevisions(List<IBazaarLogMessage> logMessages) {
        if (logMessages != null) {
            for (IBazaarLogMessage log : logMessages) {
                this.revisionMap.put(log.getRevision(), this.buildRevision(log));
                this.lastLoadedRevision = log.getRevision();
            }
        }
    }

    protected BazaarFileRevision buildRevision(IBazaarLogMessage log) {
        return new BazaarFileRevision(log, this.resource);
    }
}

