/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.history;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.eclipse.core.resources.IStorageBazaarRevision;

public class BazaarFileRevision
extends FileRevision {
    IResource resource;
    IBazaarLogMessage logMessage;
    IStorageBazaarRevision storageBazaarRevision;
    BazaarFileRevision parent;

    public BazaarFileRevision(IBazaarLogMessage logMessage, IResource resource) {
        this.logMessage = logMessage;
        this.resource = resource;
    }

    public BazaarFileRevision(IBazaarLogMessage mergedLog, IResource resource, BazaarFileRevision parentRevision) {
        this(mergedLog, resource);
        this.parent = parentRevision;
    }

    public IBazaarLogMessage getIBazaarLogMessage() {
        return this.logMessage;
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getContentIdentifier() {
        return this.logMessage.getRevision().toString();
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.storageBazaarRevision == null) {
            this.storageBazaarRevision = new IStorageBazaarRevision(this.resource, this.logMessage.getRevision());
        }
        return this.storageBazaarRevision;
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public BazaarFileRevision[] getChildren() {
        ArrayList<BazaarFileRevision> childs = new ArrayList<BazaarFileRevision>();
        if (this.logMessage.getMerged() != null && this.logMessage.getMerged().size() > 0) {
            for (IBazaarLogMessage mergedLog : this.logMessage.getMerged()) {
                childs.add(this.buildChild(mergedLog));
            }
        }
        return childs.toArray(new BazaarFileRevision[0]);
    }

    protected BazaarFileRevision buildChild(IBazaarLogMessage mergedLog) {
        return new BazaarFileRevision(mergedLog, this.resource, this);
    }

    public boolean hasChildren() {
        return this.logMessage.getMerged() != null && this.logMessage.getMerged().size() > 0;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public BazaarFileRevision getParent() {
        return this.parent;
    }

    public BazaarRevision getRevision() {
        return this.logMessage.getRevision();
    }

    public int compareRevisionTo(BazaarFileRevision other) {
        if (other != null) {
            return this.logMessage.getRevision().compareTo(other.getRevision());
        }
        return 1;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getRevision() == null ? 0 : this.getRevision().hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BazaarFileRevision other = (BazaarFileRevision)((Object)obj);
        if (this.parent == null ? other.parent != null : !this.parent.equals((Object)other.parent)) {
            return false;
        }
        return !(this.getRevision() == null ? other.getRevision() != null : !this.getRevision().equals((Object)other.getRevision()));
    }
}

