/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.listeners.AbstractResourceChangeListener;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;
import org.vcs.bazaar.eclipse.core.utils.PreferenceHelper;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileModificationManager
extends AbstractResourceChangeListener {
    private static final Object BZRIGNORE_NAME = ".bzrignore";
    protected int INTERESTING_CHANGES = 323840;

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getBuildKind() != 0) {
                return;
            }
            final ArrayList<IResource> modifiedResources = new ArrayList<IResource>();
            final AtomicReference<Boolean> bzrignoreChanged = new AtomicReference<Boolean>(false);
            EclipseBazaarCore.trace("file_modification_manager", "FileModificationManager#resourceChanged", new Object[0]);
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    EclipseBazaarCore.trace("file_modification_manager", " DeltaVisitor: ", resource);
                    if (resource.getType() == 8) {
                        return true;
                    }
                    if (resource.getName().equals(BZRIGNORE_NAME)) {
                        bzrignoreChanged.set(true);
                        modifiedResources.add(resource.getProject());
                        return false;
                    }
                    if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)EclipseBazaarCore.getProviderID()) == null) {
                        FileModificationManager.this.handleAutoShare(modifiedResources, delta, resource);
                        return false;
                    }
                    if (delta.getKind() == 4 && (delta.getFlags() & 0x400000) != 0) {
                        modifiedResources.add(resource);
                        return true;
                    }
                    if (Team.isIgnoredHint((IResource)resource) || !ResourceUtil.shouldHandle(resource, false)) {
                        return false;
                    }
                    if (resource.getType() == 1) {
                        EclipseBazaarCore.trace("file_modification_manager", "  File", new Object[0]);
                        return FileModificationManager.this.handleFile(modifiedResources, delta, resource);
                    }
                    if (resource.getType() == 2) {
                        EclipseBazaarCore.trace("file_modification_manager", "  Folder", new Object[0]);
                        return FileModificationManager.this.handleFolder(modifiedResources, delta, resource);
                    }
                    if (resource.getType() == 4 && resource.exists()) {
                        EclipseBazaarCore.trace("file_modification_manager", "  Project", new Object[0]);
                        return FileModificationManager.this.handleProject(modifiedResources, delta, (IProject)resource);
                    }
                    return true;
                }
            }, 4);
            EclipseBazaarCore.trace("file_modification_manager", "FileModificationManager#collectedChanges: ", modifiedResources.toArray(new IResource[0]));
            if (modifiedResources.size() > 0) {
                this.refreshResources(modifiedResources, bzrignoreChanged.get() != false ? 4 : 1);
            }
        }
        catch (CoreException e) {
            EclipseBazaarCore.log(e.getStatus().getMessage(), e.getStatus().getSeverity());
        }
    }

    private boolean handleFile(List<IResource> modifiedResources, IResourceDelta delta, IResource resource) {
        if (resource.exists() && delta.getKind() == 4 && (delta.getFlags() & this.INTERESTING_CHANGES) != 0) {
            EclipseBazaarCore.trace("file_modification_manager", "   InterestingChanges: ", resource, delta.getFlags());
            modifiedResources.add(resource);
        } else if (delta.getKind() == 1 && resource.exists()) {
            EclipseBazaarCore.trace("file_modification_manager", "   added/changed: ", resource);
            modifiedResources.add(resource);
        } else if (delta.getKind() == 2) {
            EclipseBazaarCore.trace("file_modification_manager", "   Removed: ", resource);
            modifiedResources.add(resource);
        }
        return true;
    }

    private boolean handleFolder(List<IResource> modifiedResources, IResourceDelta delta, IResource resource) throws CoreException {
        if (delta.getKind() == 1) {
            EclipseBazaarCore.trace("file_modification_manager", "   Added: ", resource);
            modifiedResources.add(resource);
            return true;
        }
        if (delta.getKind() == 2) {
            EclipseBazaarCore.trace("file_modification_manager", "   Removed: ", resource);
            modifiedResources.add(resource);
            return false;
        }
        if (resource.exists() && delta.getKind() == 4) {
            return !resource.isLinked(512) && !resource.isDerived();
        }
        return true;
    }

    private boolean handleProject(List<IResource> modifiedResources, IResourceDelta delta, IProject project) throws CoreException {
        if (!project.isAccessible()) {
            EclipseBazaarCore.getDefault().getLogCacheManager().purgeCache(project);
            EclipseBazaarCore.getDefault().getStatusCacheManager().purgeCache(project);
            return false;
        }
        if ((delta.getFlags() & 0x4000) != 0) {
            EclipseBazaarCore.getDefault().getLogCacheManager().purgeCache(project);
            modifiedResources.add((IResource)project);
            return false;
        }
        if (delta.getKind() == 1) {
            EclipseBazaarCore.trace("file_modification_manager", "  Added: ", project);
            modifiedResources.add((IResource)project);
            return false;
        }
        if (delta.getKind() == 2) {
            EclipseBazaarCore.trace("file_modification_manager", "   Removed", project);
            modifiedResources.add((IResource)project);
            return false;
        }
        return true;
    }

    private void handleAutoShare(List<IResource> modifiedResources, IResourceDelta delta, IResource resource) {
        IPath root;
        if (!PreferenceHelper.getBoolean("auto_share_projects")) {
            return;
        }
        if (resource.getType() != 4) {
            return;
        }
        if (!resource.exists()) {
            return;
        }
        IProject project = (IProject)resource;
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        if (provider != null) {
            return;
        }
        if ((delta.getFlags() & 0x4000) != 0 && (root = ResourceUtil.findRootLocation(project)) != null) {
            try {
                BazaarTeamProvider.registerProject(project);
                modifiedResources.add(resource);
            }
            catch (CoreException e) {
                EclipseBazaarCore.log(e.getStatus().getMessage(), e.getStatus().getSeverity());
            }
        }
    }
}

