/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.listeners;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.listeners.AbstractResourceChangeListener;
import org.vcs.bazaar.eclipse.core.listeners.BzrChangeStateEvent;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;

public class SyncFileChangeListener
extends AbstractResourceChangeListener {
    protected int INTERESTING_CHANGES = 307456;

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            final ArrayList<IResource> affectedResources = new ArrayList<IResource>();
            final HashSet<IResource> closedProjects = new HashSet<IResource>();
            EclipseBazaarCore.trace("metadir_change_listener", "SyncFileChangeListener#collectingChanges/eventkind:" + event.getType(), new Object[0]);
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 8) {
                        return true;
                    }
                    if (resource.getType() == 4) {
                        if (!resource.isAccessible()) {
                            closedProjects.add(resource);
                            return false;
                        }
                        return ResourceUtil.shouldHandle(resource);
                    }
                    String name = resource.getName();
                    IContainer toBeNotified = null;
                    if (".bzr".equals(name)) {
                        int kind = delta.getKind();
                        toBeNotified = SyncFileChangeListener.this.handleBzrDir((IContainer)resource, kind);
                    } else if (ResourceUtil.isInsideMetaFolder(resource)) {
                        toBeNotified = resource.getParent();
                    } else {
                        return false;
                    }
                    if (toBeNotified != null && !affectedResources.contains(toBeNotified)) {
                        affectedResources.add(toBeNotified);
                        return false;
                    }
                    return true;
                }
            }, 2);
            if (closedProjects.size() > 0) {
                BzrChangeStateEvent bzrEvent = new BzrChangeStateEvent(this, closedProjects, 1);
                EclipseBazaarCore.broadcastModificationStateChanges(bzrEvent);
            }
            if (affectedResources.size() > 0) {
                this.refreshResources(affectedResources, 1);
            }
        }
        catch (CoreException e) {
            EclipseBazaarCore.log(e);
        }
    }

    protected IContainer handleBzrDir(IContainer bzrDir, int kind) {
        if ((kind & this.INTERESTING_CHANGES) != 0) {
            if (!bzrDir.isTeamPrivateMember() && kind == 1) {
                try {
                    bzrDir.setTeamPrivateMember(true);
                }
                catch (CoreException e) {
                    EclipseBazaarCore.log(e);
                }
            }
            return bzrDir;
        }
        return null;
    }
}

