/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.log;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.log.LogUpdater;
import org.vcs.bazaar.eclipse.core.model.IBzrResource;
import org.vcs.bazaar.eclipse.core.utils.PreferenceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogCacheManager {
    private static final int INTERESTING_CHANGES = 16;
    public static final QualifiedName BZR_SYNC_KEY = new QualifiedName(EclipseBazaarCore.getPluginId(), "bzr-log-sync-key");
    private LogUpdater logUpdater;

    public LogCacheManager() {
        ResourcesPlugin.getWorkspace().getSynchronizer().add(BZR_SYNC_KEY);
        this.logUpdater = new LogUpdater();
    }

    public IBazaarLogMessage getLastLog(IBzrResource resource) throws CoreException {
        return this.getLogs(resource, null, 1).get(0);
    }

    public List<IBazaarLogMessage> getLogs(IResource resource, IBazaarRevisionSpec revision, boolean limit) throws CoreException {
        if (!resource.isAccessible() || resource.isPhantom() || resource.isLinked()) {
            return Collections.emptyList();
        }
        return this.getLogs((IBzrResource)BzrWorkspaceRoot.getBzrResourceFor(resource), revision, limit);
    }

    public List<IBazaarLogMessage> getLogs(IBzrResource resource, IBazaarRevisionSpec revision, boolean limit) throws CoreException {
        return this.basicGetLog(resource, this.logUpdater, revision, limit ? this.getLimit() : null);
    }

    public List<IBazaarLogMessage> getLogs(IBzrResource resource, IBazaarRevisionSpec revision, Integer limit) throws CoreException {
        return this.basicGetLog(resource, this.logUpdater, revision, limit);
    }

    private List<IBazaarLogMessage> basicGetLog(IBzrResource resource, LogUpdater strategy, IBazaarRevisionSpec revision, Integer limit) throws CoreException {
        EclipseBazaarCore.trace("log_cache", "LogCacheManager.basicGetlog: " + resource.getName(), new Object[0]);
        return strategy.fetchLog(resource, (IProgressMonitor)new NullProgressMonitor(), revision, limit);
    }

    private Integer getLimit() {
        Integer limit = null;
        int logLimit = PreferenceHelper.getInt("pref_performance_log_limit");
        if (logLimit != 0) {
            limit = logLimit;
        }
        return limit;
    }

    public void purgeCache(IProject root) throws CoreException {
    }
}

