/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.model;

import java.util.EnumSet;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarStatus;

public class BzrStatus {
    protected final EnumSet<BazaarStatusKind> statuses = EnumSet.noneOf(BazaarStatusKind.class);

    public boolean isAdded() {
        return this.contains(BazaarStatusKind.CREATED);
    }

    public boolean isDeleted() {
        return this.contains(BazaarStatusKind.DELETED);
    }

    public boolean isKindChange() {
        return this.contains(BazaarStatusKind.KIND_CHANGED);
    }

    public boolean isHasConflicts() {
        return this.contains(BazaarStatusKind.HAS_CONFLICTS);
    }

    public boolean isModified() {
        return this.contains(BazaarStatusKind.MODIFIED);
    }

    public boolean isPendingMerge() {
        return this.contains(BazaarStatusKind.PENDING_MERGE);
    }

    public boolean isRenamed() {
        return this.contains(BazaarStatusKind.RENAMED);
    }

    public boolean isUnchanged() {
        return this.contains(BazaarStatusKind.UNCHANGED);
    }

    public boolean isUnknown() {
        return this.contains(BazaarStatusKind.UNKNOWN);
    }

    public boolean isUnversioned() {
        return this.contains(BazaarStatusKind.UNVERSIONED);
    }

    public boolean isVersioned() {
        return this.contains(BazaarStatusKind.VERSIONED);
    }

    public boolean isXBitChanged() {
        return this.contains(BazaarStatusKind.X_BIT_CHANGED);
    }

    public boolean isIgnored() {
        return this.contains(BazaarStatusKind.IGNORED);
    }

    public boolean isAnyModifiedStatus() {
        return this.isHasConflicts() || this.isKindChange() || this.isModified() || this.isRenamed() || this.isUnknown() || this.isXBitChanged() || this.isAdded() || this.isDeleted();
    }

    public boolean contains(BazaarStatusKind kind) {
        return this.statuses.contains(kind);
    }

    public BzrStatus(BazaarStatusKind ... kinds) {
        BazaarStatusKind[] bazaarStatusKindArray = kinds;
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            BazaarStatusKind kind = bazaarStatusKindArray[n2];
            this.statuses.add(kind);
            ++n2;
        }
    }

    public BzrStatus(IBazaarStatus aStatus) {
        for (BazaarStatusKind kind : aStatus.getStatuses()) {
            this.statuses.add(kind);
        }
    }

    public static BzrStatus modified() {
        return new BzrStatus(BazaarStatusKind.MODIFIED);
    }

    public static BzrStatus unchanged() {
        return new BzrStatus(BazaarStatusKind.UNCHANGED);
    }

    public static BzrStatus ignored() {
        return new BzrStatus(BazaarStatusKind.IGNORED);
    }

    public static BzrStatus unknown() {
        return new BzrStatus(BazaarStatusKind.UNKNOWN);
    }
}

