/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.repository;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.provider.FileHistoryProvider;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.history.BazaarHistoryProvider;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.notifications.Notification;
import org.vcs.bazaar.eclipse.core.resources.BazaarMoveDeleteHook;

public class BazaarTeamProvider
extends RepositoryProvider {
    public static final String ID = "org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider";
    private static final ResourceRuleFactory RESOURCE_RULE_FACTORY = new ResourceRuleFactory(){};
    private BzrWorkspaceRoot bzrWorkspaceRoot;
    private final FileHistoryProvider fileHistoryProvider = new BazaarHistoryProvider();

    public static void registerProject(IProject project) throws CoreException {
        RepositoryProvider.map((IProject)project, (String)ID);
    }

    public String getID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void configureProject() throws CoreException {
        if (this.bzrWorkspaceRoot == null) {
            try {
                this.bzrWorkspaceRoot = new BzrWorkspaceRoot(this.getProject());
            }
            catch (Exception exception) {
                throw new CoreException((IStatus)new Status(4, "", ""));
            }
        }
    }

    public void deconfigure() throws CoreException {
    }

    protected void deconfigured() {
        super.deconfigured();
        this.bzrWorkspaceRoot = null;
    }

    public void setProject(IProject project) {
        super.setProject(project);
        if (BzrWorkspaceRoot.isLightweightCheckout(project)) {
            EclipseBazaarCore.getDefault().sendNotification(new Notification(Notification.NotificationCategory.LIGHTWEIGHT_CHECKOUTS));
        }
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return new BazaarMoveDeleteHook();
    }

    public IFileHistoryProvider getFileHistoryProvider() {
        return this.fileHistoryProvider;
    }

    public IResourceRuleFactory getRuleFactory() {
        return RESOURCE_RULE_FACTORY;
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }

    public IBzrBranch getBranch() {
        return this.getBzrWorkspaceRoot().getBranch();
    }

    public BzrWorkspaceRoot getBzrWorkspaceRoot() {
        if (this.bzrWorkspaceRoot == null) {
            try {
                this.bzrWorkspaceRoot = new BzrWorkspaceRoot(this.getProject());
            }
            catch (Exception exception) {
                try {
                    BazaarTeamProvider.unmap((IProject)this.getProject());
                }
                catch (TeamException teamException) {}
            }
        }
        return this.bzrWorkspaceRoot;
    }
}

