/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.repository;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.subscribers.Subscriber;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;
import org.vcs.bazaar.eclipse.core.subscriber.BazaarStatusSuscriber;
import org.vcs.bazaar.eclipse.core.utils.BzrTeamStatus;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;

public class BazaarTeamProviderType
extends RepositoryProviderType {
    public void metaFilesDetected(IProject project, IContainer[] containers) {
        EclipseBazaarCore.trace("team_provider", "metaFilesDetected: ", project);
        super.metaFilesDetected(project, containers);
        if (ResourceUtil.isUnderBazaarScope(project)) {
            BackgroundJob job = new BackgroundJob(CoreTexts.BazaarTeamProviderType_backgroundJobName, project);
            job.schedule();
        }
    }

    public static void registerProject(IProject project) throws CoreException {
        BazaarTeamProvider.registerProject(project);
    }

    public Subscriber getSubscriber() {
        return BazaarStatusSuscriber.getInstance();
    }

    protected static class BackgroundJob
    extends Job {
        final IProject project;
        static final int processWork = 100;

        public BackgroundJob(String name, IProject project) {
            super(name);
            this.project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus result = BzrTeamStatus.OK_STATUS;
            try {
                try {
                    monitor.beginTask(this.getName(), 100);
                    if (RepositoryProvider.getProvider((IProject)this.project) == null) {
                        BazaarTeamProviderType.registerProject(this.project);
                    }
                }
                catch (CoreException e) {
                    result = e.getStatus();
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return result;
        }
    }
}

