/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.repository;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.model.LocalBranch;
import org.vcs.bazaar.eclipse.internal.core.model.LpBranch;
import org.vcs.bazaar.eclipse.internal.core.model.ProjectBranch;
import org.vcs.bazaar.eclipse.internal.core.model.RemoteBranch;

public class BranchFactory {
    private static Map<BranchLocation, ProjectBranch> PROJECT_BRANCHES = new HashMap<BranchLocation, ProjectBranch>();

    public static IBzrBranch getBranch(BranchLocation location) {
        if ("file".equals(location.getScheme())) {
            return new LocalBranch(location);
        }
        if ("lp".equals(location.getScheme())) {
            return new LpBranch(location);
        }
        return new RemoteBranch(location);
    }

    public static IBzrBranch findOrCreateFor(URI uri) {
        try {
            return BranchFactory.getBranch(new BranchLocation(uri));
        }
        catch (BazaarClientException bazaarClientException) {
            return null;
        }
    }

    public static IBzrBranch findOrCreateFor(String uri) {
        try {
            return BranchFactory.getBranch(new BranchLocation(uri));
        }
        catch (BazaarClientException bazaarClientException) {
            return null;
        }
    }

    public static synchronized ProjectBranch findOrCreateFor(IProject project) {
        try {
            BranchLocation location = new BranchLocation(ResourceUtil.findRootLocation(project).toOSString());
            if (!PROJECT_BRANCHES.containsKey(location)) {
                PROJECT_BRANCHES.put(location, new ProjectBranch(location));
            }
            return PROJECT_BRANCHES.get(location);
        }
        catch (BazaarClientException bazaarClientException) {
            return null;
        }
    }

    public static boolean validateBranch(String uri) {
        try {
            new BranchLocation(uri);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

