/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.resources;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalFile;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalFolder;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class BazaarMoveDeleteHook
implements IMoveDeleteHook {
    private boolean protectBzrMetadata(IResourceTree tree, IResource res) {
        if (BzrWorkspaceRoot.getProviderFor(res.getProject()) != null && ResourceUtil.isInsideMetaFolder(res)) {
            tree.failed((IStatus)new Status(4, EclipseBazaarCore.getPluginId(), CoreTexts.MoveDeleteHook_metaFolder));
            return true;
        }
        return false;
    }

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        return this.protectBzrMetadata(tree, (IResource)file);
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        return this.protectBzrMetadata(tree, (IResource)folder);
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        File file;
        IPath root = ResourceUtil.findRootLocation(project);
        tree.standardDeleteProject(project, updateFlags, monitor);
        if (root != null && (file = root.toFile()).exists() && ResourceUtil.findProjects(file).isEmpty()) {
            ResourceUtil.deleteRecursively(file);
        }
        return true;
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        if (!ResourceUtil.shouldHandle((IResource)source)) {
            return false;
        }
        IBzrLocalFile sourceResource = BzrWorkspaceRoot.getBzrFileFor((IResource)source);
        try {
            if (!BazaarMoveDeleteHook.isUnderBazaarControl(sourceResource)) {
                return false;
            }
            if (!BzrWorkspaceRoot.getBzrResourceFor((IResource)destination.getParent()).getBranch().equals(sourceResource.getBranch())) {
                return false;
            }
            try {
                monitor.beginTask("Moving file(s)", 1000);
                IContainer parentDest = destination.getParent();
                IBzrLocalFolder parentDestResource = BzrWorkspaceRoot.getBzrFolderFor(parentDest);
                if (parentDestResource == null || !parentDestResource.isManaged()) {
                    parentDestResource.getBzrWorkspaceRoot().getClient().add(new File[]{parentDest.getLocation().toFile()}, new Option[0]);
                }
                sourceResource.move(destination.getLocation());
                tree.movedFile(source, destination);
                destination.refreshLocal(0, monitor);
            }
            catch (BazaarClientException e) {
                tree.failed(BazaarException.wrapException(e).getStatus());
            }
            catch (BazaarException e) {
                tree.failed(e.getStatus());
            }
            catch (CoreException e) {
                tree.failed(e.getStatus());
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        if (!ResourceUtil.shouldHandle((IResource)source)) {
            return false;
        }
        if (source.getLocation().isPrefixOf(destination.getLocation())) {
            return false;
        }
        IBzrLocalFolder sourceResource = BzrWorkspaceRoot.getBzrFolderFor((IContainer)source);
        try {
            if (sourceResource == null || !BazaarMoveDeleteHook.isUnderBazaarControl(sourceResource)) {
                return false;
            }
            IBzrLocalFolder bzrDest = BzrWorkspaceRoot.getBzrFolderFor(destination.getParent());
            if (bzrDest == null || !bzrDest.getBranch().equals(sourceResource.getBranch())) {
                return false;
            }
            try {
                monitor.beginTask("Removing folder(s)", 1000);
                sourceResource.move(destination.getLocation());
                tree.movedFolderSubtree(source, destination);
                destination.refreshLocal(2, monitor);
            }
            catch (BazaarException e) {
                tree.failed(e.getStatus());
            }
            catch (CoreException e) {
                tree.failed(e.getStatus());
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    private static boolean isUnderBazaarControl(IBzrLocalResource resource) {
        try {
            if (resource != null) {
                return resource.isManaged();
            }
        }
        catch (CoreException e) {
            EclipseBazaarCore.log(e.getMessage(), e);
        }
        return false;
    }
}

