/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.resources;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.CatCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class IStorageBazaarRevision
extends PlatformObject
implements IEncodedStorage {
    private final IBzrBranch branch;
    private final IResource resource;
    private final BazaarRevision revision;
    private InputStream contents;
    private BranchLocation location;
    private IPath path;

    public IStorageBazaarRevision(IResource resource, IBzrBranch branch, String relativePath, BazaarRevision revision) {
        this.branch = branch;
        this.resource = resource;
        this.revision = revision;
        if (branch.getPath() != null) {
            this.path = branch.getPath().append(relativePath);
        } else {
            try {
                this.location = new BranchLocation(branch.getBranchLocation() + "/" + relativePath);
            }
            catch (BazaarClientException e) {
                EclipseBazaarCore.log((CoreException)((Object)BazaarException.wrapException(e)));
            }
        }
    }

    public IStorageBazaarRevision(IResource resource, BazaarRevision revision) {
        this.branch = BranchFactory.findOrCreateFor(resource.getProject());
        this.resource = resource;
        this.revision = revision;
        this.path = resource.getLocation();
    }

    public IStorageBazaarRevision(IStorageBazaarRevision storage, BazaarRevision revision) {
        this.branch = storage.branch;
        this.resource = storage.resource;
        this.revision = revision;
        this.path = storage.path;
        this.location = storage.location;
    }

    public IStorageBazaarRevision(IResource resource) {
        this(resource, IStorageBazaarRevision.getLastRevision(resource));
    }

    private static BazaarRevision getLastRevision(IResource resource) {
        BazaarRevision rev = null;
        try {
            rev = EclipseBazaarCore.getDefault().getStatusCacheManager().getProjectRevision(resource);
        }
        catch (BazaarException e) {
            EclipseBazaarCore.log((CoreException)((Object)e));
        }
        return rev;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public InputStream getContents() throws CoreException {
        if (this.isContainer()) {
            return null;
        }
        if (this.contents == null) {
            String charsetName = null;
            if (this.resource != null) {
                try {
                    charsetName = ((IFile)this.resource).getCharset();
                }
                catch (CoreException coreException) {}
            }
            CatCommand cmd = this.path != null ? new CatCommand(this.branch, this.path.toFile(), charsetName, this.revision) : new CatCommand(this.branch, this.location, charsetName, this.revision);
            cmd.run((IProgressMonitor)new NullProgressMonitor());
            this.contents = cmd.getContent();
        } else {
            try {
                this.contents.reset();
            }
            catch (IOException e) {
                throw BazaarException.wrapException(e);
            }
        }
        return this.contents;
    }

    public IPath getFullPath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.resource != null) {
            return this.resource.getLocation();
        }
        return null;
    }

    public String getName() {
        if (this.resource != null) {
            return this.resource.getName();
        }
        if (this.path != null) {
            return this.path.lastSegment();
        }
        if (this.location != null) {
            String name = this.location.toString();
            int index = name.lastIndexOf(47);
            if (index >= 0) {
                name = name.substring(index + 1);
            }
            return name;
        }
        return null;
    }

    public boolean isReadOnly() {
        return true;
    }

    public BazaarRevision getRevision() {
        return this.revision;
    }

    private String getResourceCharset() throws CoreException {
        String charset = null;
        try {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            charset = contentTypeManager.getDescriptionFor(this.getContents(), this.getName(), IContentDescription.ALL).getCharset();
        }
        catch (Exception exception) {}
        if (charset == null && this.resource != null && this.resource.getType() == 1) {
            charset = ((IFile)this.resource).getCharset();
        } else if (charset == null && this.resource != null) {
            return this.resource.getParent().getDefaultCharset();
        }
        return charset;
    }

    public String getCharset() throws CoreException {
        return this.getResourceCharset();
    }

    public String getCachePath() {
        return String.valueOf(this.path != null ? this.branch.getBranchLocation() + "_" + this.path.toString() : this.location.toString()) + "_" + this.getRevision().toString();
    }

    public boolean isContainer() {
        return this.resource != null && this.resource.getType() != 1;
    }
}

