/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.status;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.vcs.bazaar.eclipse.core.model.BzrStatus;
import org.vcs.bazaar.eclipse.core.status.LastLogCacheEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCacheEntry {
    private long fullReloadTimestamp;
    private final ReentrantLock lock = new ReentrantLock(true);
    private Map<IResource, BzrStatus> statusMap = new ConcurrentHashMap<IResource, BzrStatus>();
    private final HashSet<IContainer> pseudoModifiedContainers = new HashSet();
    private final LastLogCacheEntry logCache = new LastLogCacheEntry();

    public long getFullReloadTimestamp() {
        return this.fullReloadTimestamp;
    }

    public void setFullReloadTimestamp(Long fullReloadTimestamp) {
        this.fullReloadTimestamp = fullReloadTimestamp;
    }

    public boolean isInitialized() {
        return this.fullReloadTimestamp != 0L;
    }

    public void update(Map<IResource, BzrStatus> statusMap) {
        this.statusMap = new ConcurrentHashMap<IResource, BzrStatus>(statusMap);
    }

    public Map<IResource, BzrStatus> getStatusMap() {
        return this.statusMap;
    }

    public BzrStatus get(IResource resource) {
        return this.statusMap.get(resource);
    }

    public boolean isPseudoModified(IContainer container) {
        return this.pseudoModifiedContainers.contains(container);
    }

    public boolean setPseudoModified(IContainer container) {
        return this.pseudoModifiedContainers.add(container);
    }

    public boolean removePseudoModified(IContainer container) {
        return this.pseudoModifiedContainers.add(container);
    }

    public void removePseudoModified(Collection<IResource> resources) {
        this.pseudoModifiedContainers.removeAll(resources);
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public LastLogCacheEntry getLogCache() {
        return this.logCache;
    }
}

