/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.RevnoCommand;
import org.vcs.bazaar.eclipse.core.commands.StatusUpdaterCommand;
import org.vcs.bazaar.eclipse.core.listeners.BzrChangeStateEvent;
import org.vcs.bazaar.eclipse.core.model.BzrStatus;
import org.vcs.bazaar.eclipse.core.status.StatusCacheEntry;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCacheManager {
    public static final QualifiedName BZR_SYNC_KEY = new QualifiedName(EclipseBazaarCore.getPluginId(), "bzr-status-sync-key");
    public static final Object FAMILY_CACHE_UPDATE = new Object();
    private final Map<IProject, StatusCacheEntry> cache = new ConcurrentHashMap<IProject, StatusCacheEntry>();
    private boolean logCacheEnabled = true;

    public StatusCacheManager() {
        ResourcesPlugin.getWorkspace().getSynchronizer().add(BZR_SYNC_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatusCacheEntry getEntry(IProject project) {
        Map<IProject, StatusCacheEntry> map = this.cache;
        synchronized (map) {
            StatusCacheEntry entry = this.cache.get(project);
            if (entry == null) {
                entry = this.createCache(project, (IProgressMonitor)new NullProgressMonitor());
            }
            return entry;
        }
    }

    private StatusCacheEntry createCache(IProject project, IProgressMonitor monitor) {
        StatusCacheEntry entry = new StatusCacheEntry();
        this.cache.put(project, entry);
        this.scheduleRefresh((IContainer)project, entry, monitor, false, 16);
        return entry;
    }

    public BzrStatus getStatus(IResource resource) {
        if (!resource.exists() && !resource.isPhantom()) {
            return null;
        }
        if (!ResourceUtil.shouldHandle(resource, false)) {
            return null;
        }
        StatusCacheEntry entry = this.getEntry(resource.getProject());
        return entry.get(resource);
    }

    public IBazaarLogMessage getLastLog(IResource resource) {
        StatusCacheEntry entry = this.getEntry(resource.getProject());
        return entry.getLogCache().get(resource);
    }

    public BazaarRevision getProjectRevision(IResource resource) throws BazaarException {
        if (resource == null) {
            return null;
        }
        StatusCacheEntry entry = this.getEntry(resource.getProject());
        BazaarRevision rev = entry.getLogCache().getProjectRevision();
        if (rev == null) {
            entry.getLock().lock();
            try {
                rev = entry.getLogCache().getProjectRevision();
                if (rev == null) {
                    RevnoCommand cmd = new RevnoCommand((IResource)resource.getProject());
                    cmd.run((IProgressMonitor)new NullProgressMonitor());
                    rev = cmd.getRevision();
                    entry.getLogCache().setProjectRevision(rev);
                }
            }
            finally {
                entry.getLock().unlock();
            }
        }
        return rev;
    }

    private Map<IProject, List<IResource>> getResourcesByProject(Collection<IResource> resources) {
        HashMap<IProject, List<IResource>> projects = new HashMap<IProject, List<IResource>>();
        for (IResource resource : resources) {
            ArrayList<IResource> resourcesByProject = (ArrayList<IResource>)projects.get(resource.getProject());
            if (resourcesByProject == null) {
                resourcesByProject = new ArrayList<IResource>();
                projects.put(resource.getProject(), resourcesByProject);
            }
            resourcesByProject.add(resource);
        }
        return projects;
    }

    public void scheduleRefresh(Collection<IResource> resources, IProgressMonitor monitor, int decoratorChangeType) throws BazaarException {
        if (!resources.isEmpty()) {
            Map<IProject, List<IResource>> projects = this.getResourcesByProject(resources);
            for (List<IResource> res : projects.values()) {
                this.scheduleRefreshPerProject(res, monitor, decoratorChangeType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRefreshPerProject(List<IResource> resources, IProgressMonitor monitor, int decoratorChangeType) throws BazaarException {
        StatusCacheEntry entry;
        boolean shallow = decoratorChangeType == 1;
        IResource resource = resources.get(0);
        IContainer commonParent = (IContainer)(resource.getType() == 4 ? resource : resource.getParent());
        if (resources.size() > 1) {
            ArrayList<IContainer> parents = new ArrayList<IContainer>();
            IContainer parent = commonParent;
            while (parent != null && parent.getType() != 8) {
                parents.add(parent);
                parent = parent.getParent();
            }
            int index = 0;
            block4: for (IResource res : resources) {
                IContainer container;
                IContainer parent2 = container = (IContainer)(res.getType() == 4 ? res : res.getParent());
                while (parent2 != null && parent2.getType() != 8) {
                    int i = parents.indexOf(parent2);
                    if (i != -1) {
                        if (i <= index) continue block4;
                        index = i;
                        continue block4;
                    }
                    shallow = false;
                    parent2 = parent2.getParent();
                }
            }
            if (index != 0) {
                shallow = false;
            }
            commonParent = (IContainer)parents.get(index);
        }
        Map<IProject, StatusCacheEntry> map = this.cache;
        synchronized (map) {
            entry = this.cache.get(commonParent.getProject());
            if (entry == null) {
                this.createCache(commonParent.getProject(), monitor);
                return;
            }
        }
        this.scheduleRefresh(commonParent, entry, monitor, shallow, decoratorChangeType);
    }

    private void waitForWorkspaceLock(IProgressMonitor monitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            try {
                Job.getJobManager().beginRule((ISchedulingRule)root, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                Job.getJobManager().endRule((ISchedulingRule)root);
                return;
            }
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)root);
        }
    }

    private void scheduleRefresh(final IContainer resource, final StatusCacheEntry cache, IProgressMonitor monitor, final boolean shallow, final int decoratorChangeType) {
        if (decoratorChangeType == 16) {
            cache.getLogCache().setProjectRevision(null);
        }
        final long updateStart = System.currentTimeMillis();
        Job job = new Job("Refreshing Bazaar status cache"){

            public IStatus run(IProgressMonitor monitor) {
                StatusCacheManager.this.waitForWorkspaceLock(monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                cache.getLock().lock();
                try {
                    Map<IResource, BzrStatus> statusMap;
                    boolean verbose;
                    boolean bl = verbose = decoratorChangeType == 16 && StatusCacheManager.this.logCacheEnabled;
                    if (!(updateStart >= cache.getFullReloadTimestamp() || verbose && updateStart >= cache.getLogCache().getFullReloadTimestamp())) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    long timestamp = System.currentTimeMillis();
                    if (StatusCacheManager.this.isInsideIgnoredFolder(resource, cache)) {
                        final HashMap<IResource, BzrStatus> ignoredMap = new HashMap<IResource, BzrStatus>();
                        resource.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                System.out.println(resource);
                                ignoredMap.put(resource, BzrStatus.ignored());
                                return true;
                            }
                        }, 2, 4);
                        statusMap = ignoredMap;
                    } else {
                        StatusUpdaterCommand cmd = StatusCacheManager.this.runCommand((IResource)resource, shallow, verbose, monitor);
                        statusMap = cmd.getStatus();
                        if (verbose) {
                            StatusCacheManager.this.updateLastLogCache(resource, cache, timestamp, cmd);
                        }
                    }
                    Set<IResource> refreshed = StatusCacheManager.this.updateStatusCache(resource, cache, shallow, timestamp, statusMap);
                    BzrChangeStateEvent event = new BzrChangeStateEvent((Object)this, refreshed, decoratorChangeType);
                    EclipseBazaarCore.broadcastModificationStateChanges(event);
                    EclipseBazaarCore.trace("status_cache", "Bzr cache updated: ", resource, shallow, System.currentTimeMillis() - timestamp);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception exception) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    cache.getLock().unlock();
                }
            }

            public boolean belongsTo(Object family) {
                if (family.equals(FAMILY_CACHE_UPDATE)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.schedule();
    }

    protected boolean isInsideIgnoredFolder(IContainer resource, StatusCacheEntry cache) {
        IContainer r = resource;
        while (r.getType() != 4) {
            BzrStatus status = cache.get((IResource)r);
            if (status != null && status.isIgnored()) {
                return true;
            }
            r = r.getParent();
        }
        return false;
    }

    protected void updateLastLogCache(IContainer resource, StatusCacheEntry cache, long timestamp, StatusUpdaterCommand cmd) {
        cache.getLogCache().update(cmd.getLogMap());
        if (resource.getType() == 4) {
            cache.getLogCache().setFullReloadTimestamp(timestamp);
        }
    }

    protected Set<IResource> updateStatusCache(IContainer resource, StatusCacheEntry cache, boolean shallow, long timestamp, Map<IResource, BzrStatus> newMap) {
        HashSet<IResource> refreshed = new HashSet<IResource>();
        HashMap<IResource, BzrStatus> fullMap = new HashMap<IResource, BzrStatus>();
        if (shallow || resource.getType() != 4) {
            fullMap.putAll(cache.getStatusMap());
            if (!shallow) {
                HashSet<IResource> obsolete = new HashSet<IResource>();
                for (IResource res : fullMap.keySet()) {
                    if (res.equals((Object)resource) || !resource.getFullPath().isPrefixOf(res.getFullPath())) continue;
                    obsolete.add(res);
                }
                fullMap.keySet().removeAll(obsolete);
                refreshed.addAll(obsolete);
            }
        } else {
            refreshed.addAll(cache.getStatusMap().keySet());
        }
        fullMap.putAll(newMap);
        refreshed.addAll(newMap.keySet());
        refreshed.add((IResource)resource);
        this.addPseudoModifiedFolders(resource, newMap, fullMap, cache);
        cache.update(fullMap);
        if (!shallow && resource.getType() == 4) {
            cache.setFullReloadTimestamp(timestamp);
        }
        return refreshed;
    }

    private void addPseudoModifiedFolders(IContainer resource, Map<IResource, BzrStatus> newMap, Map<IResource, BzrStatus> fullMap, StatusCacheEntry cache) {
        cache.removePseudoModified(newMap.keySet());
        HashMap<IContainer, BzrStatus> modified = new HashMap<IContainer, BzrStatus>();
        for (Map.Entry<IResource, BzrStatus> entry : newMap.entrySet()) {
            if (!entry.getValue().isAnyModifiedStatus()) continue;
            IContainer parent = entry.getKey().getParent();
            while (parent.getType() != 8) {
                BzrStatus status;
                if (!modified.containsKey(parent) && ((status = fullMap.get(parent)) == null || status.isUnchanged())) {
                    modified.put(parent, BzrStatus.modified());
                    cache.setPseudoModified(parent);
                }
                parent = parent.getParent();
            }
        }
        fullMap.putAll(modified);
        IContainer parent = resource;
        while (parent.getType() != 8) {
            if (modified.containsKey(parent)) break;
            if (cache.isPseudoModified(parent)) {
                boolean stillPseudoModified = false;
                try {
                    IResource[] iResourceArray = parent.members(4);
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource child = iResourceArray[n2];
                        if (modified.containsKey(child)) {
                            stillPseudoModified = true;
                            break;
                        }
                        BzrStatus status = fullMap.get(child);
                        if (status != null && status.isAnyModifiedStatus()) {
                            stillPseudoModified = true;
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
                if (stillPseudoModified) break;
                fullMap.put((IResource)parent, BzrStatus.unchanged());
                cache.removePseudoModified(parent);
            }
            parent = parent.getParent();
        }
    }

    protected StatusUpdaterCommand runCommand(IResource resource, boolean shallow, boolean verbose, IProgressMonitor monitor) throws BazaarException {
        EclipseBazaarCore.trace("status_command", "StatusUpdater.statusesToUpdate: " + resource.getName() + "/" + shallow + "/" + verbose, new Object[0]);
        StatusUpdaterCommand cmd = new StatusUpdaterCommand(BzrWorkspaceRoot.getBzrResourceFor(resource), shallow, verbose);
        cmd.run(monitor);
        return cmd;
    }

    public void purgeCache(IProject project) throws CoreException {
        this.cache.remove(project);
    }

    public void setLogCacheEnabled(boolean logCacheEnabled) {
        if (logCacheEnabled != this.logCacheEnabled && logCacheEnabled) {
            this.cache.clear();
        }
        this.logCacheEnabled = logCacheEnabled;
    }
}

