/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.subscriber;

import java.io.BufferedInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.resources.IStorageBazaarRevision;

public class BazaarResourceVariant
extends CachedResourceVariant {
    private IStorageBazaarRevision storage;
    private byte[] bytes;

    public BazaarResourceVariant(IStorageBazaarRevision file) {
        this.storage = file;
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
        try {
            this.setContents(new BufferedInputStream(this.storage.getContents()), monitor);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    protected String getCacheId() {
        return EclipseBazaarCore.getPluginId();
    }

    protected String getCachePath() {
        return this.storage.getCachePath();
    }

    public byte[] asBytes() {
        if (this.bytes == null) {
            this.bytes = this.getCachePath().getBytes();
        }
        return this.bytes;
    }

    public String getContentIdentifier() {
        return this.storage.getRevision().toString();
    }

    public String getName() {
        return this.storage.getName();
    }

    public boolean isContainer() {
        return this.storage.isContainer();
    }
}

