/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.subscriber;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.resources.IStorageBazaarRevision;
import org.vcs.bazaar.eclipse.core.subscriber.BazaarLocalVariantComparator;
import org.vcs.bazaar.eclipse.core.subscriber.BazaarResourceVariant;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class BazaarStatusSuscriber
extends Subscriber {
    private static final String NAME = "BazaarStatusSuscriber";
    private final BazaarLocalVariantComparator comparatorObj = new BazaarLocalVariantComparator();
    private static final BazaarStatusSuscriber instance = new BazaarStatusSuscriber();

    public static BazaarStatusSuscriber getInstance() {
        return instance;
    }

    private BazaarStatusSuscriber() {
    }

    public String getName() {
        return NAME;
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        return ResourceUtil.shouldHandle(resource);
    }

    public IResource[] members(IResource resource) throws TeamException {
        try {
            if (resource.getType() == 1) {
                return new IResource[0];
            }
            IContainer container = (IContainer)resource;
            ArrayList<IResource> existingChildren = new ArrayList<IResource>(Arrays.asList(container.members()));
            existingChildren.addAll(Arrays.asList(container.findDeletedMembersWithHistory(2, null)));
            return existingChildren.toArray(new IResource[existingChildren.size()]);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    public IResource[] roots() {
        return ResourceUtil.findProjects();
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        if (!resource.exists()) {
            return null;
        }
        return this.getSyncInfo(resource, null, null);
    }

    private SyncInfo getSyncInfo(IResource resource, IStorageBazaarRevision base, IStorageBazaarRevision remote) throws TeamException {
        try {
            if (base == null) {
                base = new IStorageBazaarRevision(resource, EclipseBazaarCore.getDefault().getStatusCacheManager().getProjectRevision(resource));
            }
            BazaarResourceVariant baseFileHist = new BazaarResourceVariant(base);
            BazaarResourceVariant remoteFileHist = null;
            if (remote != null) {
                remoteFileHist = new BazaarResourceVariant(remote);
            }
            SyncInfo info = new SyncInfo(resource, (IResourceVariant)baseFileHist, (IResourceVariant)remoteFileHist, (IResourceVariantComparator)this.comparatorObj);
            info.init();
            return info;
        }
        catch (CoreException e) {
            throw BazaarException.wrapException(e);
        }
    }

    public IResourceVariantComparator getResourceComparator() {
        return this.comparatorObj;
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
    }
}

