/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.synchronize;

import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.core.variants.SessionResourceVariantByteStore;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.core.resources.IStorageBazaarRevision;
import org.vcs.bazaar.eclipse.core.subscriber.BazaarResourceVariant;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarResourceVariantComparator;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSyncCache;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSyncCacheEntry;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSyncCacheManager;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSyncInfo;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSynchronizeData;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;

public class BazaarResourceVariantTreeSubscriber
extends Subscriber {
    private static final String NAME = "BazaarResourceVariantTreeSubscriber";
    private final BazaarSynchronizeData syncData;
    private final BazaarResourceVariantComparator comparatorObj = new BazaarResourceVariantComparator();
    protected ResourceVariantByteStore remoteSyncStateStore = new SessionResourceVariantByteStore();
    private BazaarSyncCache cache;
    private IResource[] roots;

    public BazaarResourceVariantTreeSubscriber(BazaarSynchronizeData syncData) {
        this.syncData = syncData;
    }

    public String getName() {
        return NAME;
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        if (resource.getType() != 1) {
            return false;
        }
        return ResourceUtil.shouldHandle(resource);
    }

    public IResource[] members(IResource res) throws TeamException {
        if (res.getType() == 1 || !this.syncData.isIncluded(res)) {
            return new IResource[0];
        }
        HashSet<IResource> members = new HashSet<IResource>();
        try {
            IResource[] iResourceArray = ((IContainer)res).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                members.add(member);
                ++n2;
            }
            iResourceArray = this.syncData.getResources();
            n = iResourceArray.length;
            n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (!res.equals((Object)resource) && res.getFullPath().isPrefixOf(resource.getFullPath())) {
                    members.add(resource);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            EclipseBazaarCore.log(e);
        }
        return members.toArray(new IResource[members.size()]);
    }

    public IResource[] roots() {
        if (this.roots == null) {
            this.roots = this.syncData.getProjects();
        }
        return this.roots;
    }

    public IResourceVariantComparator getResourceComparator() {
        return this.comparatorObj;
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(CoreTexts.BazaarResourceVariantTreeSubscriber_fetchTaskName, 100);
        try {
            this.cache = BazaarSyncCacheManager.getCache(this.syncData);
            this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])this.cache.getChangedResources()));
        }
        finally {
            monitor.done();
        }
    }

    public void init(IProgressMonitor monitor) {
        monitor.beginTask(CoreTexts.BazaarResourceVariantTreeSubscriber_fetchTaskName, 100);
        try {
            this.cache = BazaarSyncCacheManager.getCache(this.syncData);
        }
        finally {
            monitor.done();
        }
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        if (this.cache == null) {
            return null;
        }
        BazaarSyncCacheEntry entry = this.cache.getEntry(resource);
        if (entry == null) {
            return null;
        }
        IBzrBranch branch = BranchFactory.getBranch(this.syncData.getRemoteLocation());
        BazaarResourceVariant base = null;
        BazaarResourceVariant remote = null;
        if (entry.getChangeType() != BazaarSyncCacheEntry.ChangeType.ADD) {
            base = new BazaarResourceVariant(new IStorageBazaarRevision(resource, entry.getBaseRevision()));
        }
        if (!(entry.getChangeType() == BazaarSyncCacheEntry.ChangeType.DELETE && entry.getDirection() == BazaarSyncCacheEntry.Direction.INCOMING || entry.getChangeType() == BazaarSyncCacheEntry.ChangeType.ADD && entry.getDirection() == BazaarSyncCacheEntry.Direction.OUTGOING)) {
            remote = new BazaarResourceVariant(new IStorageBazaarRevision(resource, branch, entry.getPath(), entry.getRemoteRevision()));
        }
        BazaarSyncInfo info = new BazaarSyncInfo(entry, resource, (IResourceVariant)base, (IResourceVariant)remote, this.comparatorObj);
        info.init();
        return info;
    }
}

