/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.synchronize;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.BazaarTreeStatus;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSyncCacheEntry;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarSyncCache {
    private Map<IResource, BazaarSyncCacheEntry> cache;

    public BazaarSyncCache(IPath branchPath, List<IBazaarLogMessage> mine, List<IBazaarLogMessage> other, BazaarTreeStatus status, BazaarRevision currentRevision) {
        Map<String, ChangeAndRevision> incoming = this.getChanges(other, null);
        HashMap<String, ChangeAndRevision> outgoingStatus = new HashMap<String, ChangeAndRevision>();
        this.addStatuses(outgoingStatus, status.getStatus(), BazaarRevision.getRevision((int)(Integer.parseInt(currentRevision.getValue()) + 1)));
        Map<String, ChangeAndRevision> outgoing = this.getChanges(mine, outgoingStatus);
        this.cache = new HashMap<IResource, BazaarSyncCacheEntry>();
        for (BazaarSyncCacheEntry e : this.mergeChanges(incoming, outgoing, currentRevision)) {
            IResource resource = ResourceUtil.getIResource(branchPath.append(e.getPath()), e.isDirectory());
            if (resource == null) continue;
            this.cache.put(resource, e);
        }
    }

    public BazaarSyncCacheEntry getEntry(IResource resource) {
        return this.cache.get(resource);
    }

    private Collection<BazaarSyncCacheEntry> mergeChanges(Map<String, ChangeAndRevision> incoming, Map<String, ChangeAndRevision> outgoing, BazaarRevision currentRevision) {
        HashSet<BazaarSyncCacheEntry> entries = new HashSet<BazaarSyncCacheEntry>();
        HashSet<String> keys = new HashSet<String>(incoming.keySet());
        keys.addAll(outgoing.keySet());
        int maxLocalRevision = Integer.parseInt(currentRevision.getValue());
        for (String key : keys) {
            int localBase;
            ChangeAndRevision localChange = outgoing.get(key);
            ChangeAndRevision remoteChange = incoming.get(key);
            BazaarSyncCacheEntry entry = null;
            if (localChange == null) {
                int remoteBase = Integer.parseInt(remoteChange.getMinRevision().getValue()) - 1;
                BazaarRevision rev = BazaarRevision.getRevision((int)Math.max(1, Math.min(maxLocalRevision, remoteBase)));
                entry = new BazaarSyncCacheEntry(key, BazaarSyncCacheEntry.Direction.INCOMING, remoteChange.getChangeType(), rev, remoteChange.getMaxRevision(), remoteChange.isDirectory());
            } else if (remoteChange == null) {
                localBase = Integer.parseInt(localChange.getMinRevision().getValue()) - 1;
                BazaarRevision rev = BazaarRevision.getRevision((int)Math.max(1, Math.min(maxLocalRevision, localBase)));
                entry = new BazaarSyncCacheEntry(key, BazaarSyncCacheEntry.Direction.OUTGOING, localChange.getChangeType(), rev, rev, localChange.isDirectory());
            } else {
                if (localChange.getChangeType() == BazaarSyncCacheEntry.ChangeType.DELETE && remoteChange.getChangeType() == BazaarSyncCacheEntry.ChangeType.DELETE) continue;
                localBase = Integer.parseInt(localChange.getMinRevision().getValue()) - 1;
                int remoteBase = Integer.parseInt(remoteChange.getMinRevision().getValue()) - 1;
                BazaarRevision rev = BazaarRevision.getRevision((int)Math.max(1, Math.min(localBase, remoteBase)));
                entry = new BazaarSyncCacheEntry(key, BazaarSyncCacheEntry.Direction.CONFLICTING, localChange.getChangeType() == remoteChange.getChangeType() ? localChange.getChangeType() : BazaarSyncCacheEntry.ChangeType.MODIFY, rev, remoteChange.getMaxRevision(), localChange.isDirectory());
            }
            entries.add(entry);
        }
        return entries;
    }

    private Map<String, ChangeAndRevision> getChanges(List<IBazaarLogMessage> logs, Map<String, ChangeAndRevision> initialChanges) {
        HashMap<String, ChangeAndRevision> changes = new HashMap<String, ChangeAndRevision>();
        if (initialChanges != null) {
            changes.putAll(initialChanges);
        }
        if (logs != null) {
            for (IBazaarLogMessage log : logs) {
                List statuses = log.getAffectedFiles();
                this.addStatuses(changes, statuses, log.getRevision());
            }
        }
        return changes;
    }

    private void addStatuses(Map<String, ChangeAndRevision> changes, Collection<IBazaarStatus> statuses, BazaarRevision revision) {
        for (IBazaarStatus status : statuses) {
            String path = status.getPath();
            BazaarSyncCacheEntry.ChangeType changeType = null;
            changeType = status.contains(BazaarStatusKind.CREATED) ? BazaarSyncCacheEntry.ChangeType.ADD : (status.contains(BazaarStatusKind.DELETED) ? BazaarSyncCacheEntry.ChangeType.DELETE : BazaarSyncCacheEntry.ChangeType.MODIFY);
            if (changeType == BazaarSyncCacheEntry.ChangeType.ADD || !changes.containsKey(path)) {
                changes.put(path, new ChangeAndRevision(changeType, revision, status.isDirectory()));
                continue;
            }
            changes.get(path).setMinRevision(revision);
        }
    }

    public IResource[] getChangedResources() {
        return this.cache.keySet().toArray(new IResource[this.cache.keySet().size()]);
    }

    private static class ChangeAndRevision {
        private final BazaarSyncCacheEntry.ChangeType changeType;
        private final BazaarRevision maxRevision;
        private final boolean directory;
        private BazaarRevision minRevision;

        public ChangeAndRevision(BazaarSyncCacheEntry.ChangeType changeType, BazaarRevision revision, boolean directory) {
            this.changeType = changeType;
            this.maxRevision = revision;
            this.minRevision = revision;
            this.directory = directory;
        }

        public BazaarSyncCacheEntry.ChangeType getChangeType() {
            return this.changeType;
        }

        public BazaarRevision getMinRevision() {
            return this.minRevision;
        }

        public void setMinRevision(BazaarRevision minRevision) {
            this.minRevision = minRevision;
        }

        public BazaarRevision getMaxRevision() {
            return this.maxRevision;
        }

        public boolean isDirectory() {
            return this.directory;
        }
    }
}

