/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.synchronize;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.BazaarTreeStatus;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IMissingOptions;
import org.vcs.bazaar.client.commandline.syntax.IStatusOptions;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSyncCache;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSynchronizeData;

public class BazaarSyncCacheManager {
    public static BazaarSyncCache getCache(BazaarSynchronizeData syncData) {
        try {
            IProject project = syncData.getProjects()[0];
            IBazaarClient client = BzrWorkspaceRoot.getBzrWorkspaceRootFor(project).getClient();
            IBzrLocalBranch branch = BzrWorkspaceRoot.getBranchFor(project);
            Map missing = client.missing(branch.getFile(), syncData.getRemoteLocation(), new Option[]{IMissingOptions.VERBOSE});
            List mine = (List)missing.get("MINE");
            List other = (List)missing.get("OTHER");
            BazaarTreeStatus status = client.status(new File[]{branch.getFile()}, new Option[]{IStatusOptions.VERSIONED});
            BazaarRevision revno = client.revno(branch.getBranchLocation());
            return new BazaarSyncCache(branch.getPath(), mine, other, status, revno);
        }
        catch (Exception e) {
            EclipseBazaarCore.log(e.getMessage(), e);
            return null;
        }
    }
}

