/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.synchronize;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.vcs.bazaar.client.core.BranchLocation;

public class BazaarSynchronizeData {
    private final IResource[] resources;
    private final BranchLocation location;
    private final Set<IProject> projects = new HashSet<IProject>();

    public BazaarSynchronizeData(IResource[] resources, BranchLocation location) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.projects.add(resource.getProject());
            ++n2;
        }
        this.resources = resources;
        this.location = location;
    }

    public boolean isIncluded(IResource resource) {
        if (resource == null || resource.getProject() == null) {
            return false;
        }
        if (!this.projects.contains(resource.getProject())) {
            return false;
        }
        IPath path = resource.getLocation();
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res.getLocation().isPrefixOf(path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IProject[] getProjects() {
        return this.projects.toArray(new IProject[this.projects.size()]);
    }

    public IResource[] getResources() {
        return this.resources;
    }

    public BranchLocation getRemoteLocation() {
        return this.location;
    }
}

