/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.utils;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamStatus;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.model.IBzrResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class BzrTeamStatus
extends TeamStatus
implements IStatus {
    private IBzrResource commandRoot;

    public BzrTeamStatus() {
        super(0, EclipseBazaarCore.getPluginId(), 0, "", null, null);
    }

    public BzrTeamStatus(int severity, int code, String message, Throwable t, IResource resource) {
        super(severity, EclipseBazaarCore.getPluginId(), code, message, t, resource);
    }

    public BzrTeamStatus(int severity, int code, String message, Throwable t) {
        super(severity, EclipseBazaarCore.getPluginId(), code, message, t, null);
    }

    public BzrTeamStatus(int severity, int code, String message) {
        this(severity, code, message, null);
    }

    public BzrTeamStatus(int severity, int code, IBzrResource commandRoot, String message) {
        this(severity, code, message, null);
        this.commandRoot = commandRoot;
    }

    public BzrTeamStatus(int severity, String message, Throwable t) {
        this(severity, 0, message, t);
    }

    public BzrTeamStatus(int severity, String message) {
        this(severity, severity, message, null);
    }

    public String getMessage() {
        String message = super.getMessage();
        if (this.commandRoot != null) {
            message = NLS.bind((String)CoreTexts.BzrStatus_messageWithRoot, (Object[])new String[]{this.commandRoot.getName(), message});
        }
        return message;
    }

    public boolean isInternalError() {
        Throwable ex = this.getException();
        if (ex instanceof BazaarException) {
            BazaarException bzrEx = (BazaarException)((Object)ex);
            IStatus status = bzrEx.getStatus();
            return BzrTeamStatus.isInternalError(status);
        }
        return ex != null;
    }

    public static boolean isInternalError(IStatus status) {
        if (status instanceof BzrTeamStatus) {
            return ((BzrTeamStatus)status).isInternalError();
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                if (BzrTeamStatus.isInternalError(child)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public void setInfo(String message) {
        this.setMessage(message);
        this.setSeverity(1);
    }

    public void setError(String errorMessage) {
        this.setMessage(errorMessage);
        this.setSeverity(4);
    }

    public void setError(String errorMessage, Throwable t) {
        this.setError(errorMessage);
        this.setException(t);
    }
}

