/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.RepositoryProvider;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;
import org.vcs.bazaar.eclipse.internal.core.model.ProjectBranch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    public static boolean isUnderBazaarScope(IProject project) {
        IPath projectLocation = project.getLocation();
        return ResourceUtil.findRootLocation(projectLocation.toFile()) != null;
    }

    public static IProject[] findProjects() {
        IProject[] projects;
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryProvider provider;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && (provider = RepositoryProvider.getProvider((IProject)project, (String)EclipseBazaarCore.getProviderID())) != null) {
                result.add(project);
            }
            ++n2;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public static IPath findRootLocation(IProject project) {
        File projectFile = project.getLocation().toFile();
        File location = ResourceUtil.findRootLocation(projectFile);
        return location != null ? new Path(location.toString()) : null;
    }

    public static void setMetaFolderTeamPrivate(IProject project, boolean teamPrivate) {
        try {
            IFolder folder = project.getFolder(".bzr");
            if (folder.exists()) {
                folder.setTeamPrivateMember(teamPrivate);
            }
        }
        catch (CoreException e) {
            EclipseBazaarCore.getDefault().getLog().log(e.getStatus());
        }
    }

    public static IPath getRepositoryPath(IResource resource) {
        IPath result = null;
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        if (RepositoryProvider.isShared((IProject)project)) {
            RepositoryProvider prov = RepositoryProvider.getProvider((IProject)project);
            if (prov instanceof BazaarTeamProvider) {
                BzrWorkspaceRoot bzrWorkspaceRoot = ((BazaarTeamProvider)prov).getBzrWorkspaceRoot();
                result = bzrWorkspaceRoot != null ? bzrWorkspaceRoot.getBranch().getPath() : ResourceUtil.findRootLocation(project);
            }
        } else {
            result = ResourceUtil.findRootLocation(project);
        }
        return result;
    }

    public static boolean isRepoDirInProject(IProject project) {
        IPath repoPath = ResourceUtil.getRepositoryPath((IResource)project);
        return project.getLocation().equals((Object)repoPath);
    }

    public static void markAsDirty(IResource resource) {
        IProject project = resource.getProject();
        IBzrLocalBranch branch = BzrWorkspaceRoot.getBzrWorkspaceRootFor(project).getBranch();
        if (branch instanceof ProjectBranch) {
            ((ProjectBranch)branch).setDirty(true);
        }
    }

    public static IFile getIFileForLocation(String absolutePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(absolutePath));
    }

    public static IContainer getIContainerForLocation(String absolutePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(absolutePath));
    }

    public static IResource getIFile(IBazaarStatus aStatus) {
        IFile resource = ResourceUtil.getIFileForLocation(aStatus.getAbsolutePath());
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot().getFile(ResourceUtil.getRelativePathToWorkspaceRoot(aStatus));
        }
        return resource;
    }

    public static IResource getIContainer(IBazaarStatus aStatus) {
        IContainer resource = ResourceUtil.getIContainerForLocation(aStatus.getAbsolutePath());
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot().getFolder(ResourceUtil.getRelativePathToWorkspaceRoot(aStatus));
        }
        return resource;
    }

    public static IResource getIResource(IBazaarStatus aStatus) {
        return aStatus.isDirectory() ? ResourceUtil.getIContainer(aStatus) : ResourceUtil.getIFile(aStatus);
    }

    public static IResource getIResource(IPath path, boolean directory) {
        return directory ? ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
    }

    private static IPath getRelativePathToWorkspaceRoot(IBazaarStatus status) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path statusPath = new Path(status.getAbsolutePath());
        IPath relativePath = statusPath.makeRelativeTo(root.getLocation());
        return relativePath;
    }

    public static boolean shouldHandle(IResource resource) {
        boolean shouldHandle = !resource.isDerived(512) && !resource.isLinked(512);
        IProject project = null;
        project = resource.getType() == 4 ? (IProject)resource : resource.getProject();
        return shouldHandle && project != null && RepositoryProvider.getProvider((IProject)project, (String)EclipseBazaarCore.getProviderID()) != null;
    }

    public static boolean shouldHandle(IResource resource, boolean checkProvider) {
        if (checkProvider) {
            return ResourceUtil.shouldHandle(resource);
        }
        return !resource.isLinked(512) && !resource.isDerived(512);
    }

    private static File findRootLocation(File file) {
        File parent;
        File metaFolder = new File(file, ".bzr");
        File result = null;
        result = metaFolder.exists() && metaFolder.isDirectory() && new File(metaFolder, "branch").exists() ? metaFolder.getParentFile() : ((parent = file.getParentFile()) != null && parent.canWrite() ? (parent == null ? null : ResourceUtil.findRootLocation(parent)) : null);
        return result;
    }

    public static List<File> findProjects(File location) {
        File[] dirs;
        LinkedList<File> ps = new LinkedList<File>();
        File dotProj = new File(location, ".project");
        if (dotProj.exists()) {
            ps.add(location);
            return ps;
        }
        File[] fileArray = dirs = location.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().equals(".bzr");
            }
        });
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            ps.addAll(ResourceUtil.findProjects(dir));
            ++n2;
        }
        return ps;
    }

    public static void move(File srcFile, File destFile) throws IOException {
        if (srcFile.isDirectory()) {
            ResourceUtil.moveDirectory(srcFile, destFile);
        } else {
            ResourceUtil.moveFile(srcFile, destFile);
        }
    }

    public static void moveDirectory(File srcDir, File destDir) throws IOException {
        if (!srcDir.renameTo(destDir)) {
            ResourceUtil.copyDirectory(srcDir, destDir);
            ResourceUtil.deleteRecursively(srcDir);
            if (srcDir.exists()) {
                throw new IOException("Failed to delete original directory '" + srcDir + "' after copy to '" + destDir + "'");
            }
        }
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new IOException(destDir + " cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException(destDir + " cannto be written to");
        }
        destDir.setLastModified(srcDir.lastModified());
        File[] files = srcDir.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        int i = 0;
        while (i < files.length) {
            File destFile = new File(destDir, files[i].getName());
            if (files[i].isDirectory()) {
                ResourceUtil.copyDirectory(files[i], destFile);
            } else {
                ResourceUtil.copyFile(files[i], destFile);
            }
            ++i;
        }
    }

    public static void moveFile(File srcFile, File destFile) throws FileNotFoundException, IOException {
        if (!srcFile.renameTo(destFile)) {
            ResourceUtil.copyFile(srcFile, destFile);
            srcFile.delete();
        }
    }

    public static void copyFile(File srcFile, File destFile) throws FileNotFoundException, IOException {
        if (destFile.exists()) {
            destFile.delete();
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                out.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
        destFile.setLastModified(srcFile.lastModified());
    }

    public static void deleteRecursively(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    ResourceUtil.deleteRecursively(child);
                    ++n2;
                }
            }
            file.delete();
        }
    }

    public static boolean isInsideMetaFolder(IResource resource) {
        IProject project = resource.getProject();
        return project.getFolder((IPath)new Path(".bzr")).getFullPath().isPrefixOf(resource.getFullPath());
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File folder = EclipseBazaarCore.getDefault().getStateLocation().toFile();
        return File.createTempFile(prefix, suffix, folder);
    }
}

