/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.internal.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.TeamException;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.utils.BzrTeamStatus;

public class BazaarException
extends TeamException {
    private static final long serialVersionUID = 1L;
    private String message;

    public BazaarException(CoreException e) {
        super(e);
        this.setStackTrace(e.getStackTrace());
    }

    public BazaarException(int severity, int code, String message, Throwable e, IResource resource) {
        super((IStatus)new BzrTeamStatus(severity, code, e.getMessage(), e, resource));
        this.setStackTrace(this.getStatus().getException().getStackTrace());
        this.message = message;
    }

    public BazaarException(int severity, int code, String message, Throwable e) {
        this(severity, code, message, e, null);
    }

    public BazaarException(int severity, int code, String message) {
        this(severity, code, message, new Exception(message));
    }

    public BazaarException(String message) {
        super((IStatus)new BzrTeamStatus(4, -6, message, null));
    }

    public BazaarException(String message, Throwable e) {
        this(4, -6, message, e);
    }

    public BazaarException(IStatus status) {
        super(status);
        this.message = status.getMessage();
    }

    public static BazaarException wrapException(IResource resource, String message, IOException e) {
        return new BazaarException(new BzrTeamStatus(4, -4, message, e));
    }

    public static BazaarException wrapException(IResource resource, String message, InterruptedException e) {
        return new BazaarException(new BzrTeamStatus(4, -6, message, e));
    }

    public static BazaarException wrapException(IResource resource, String message, CoreException e) {
        return new BazaarException(new BzrTeamStatus(4, e.getStatus().getCode(), message, e));
    }

    public static BazaarException wrapException(Exception e) {
        Throwable t = e;
        if (e instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)e).getTargetException();
            if (target instanceof BazaarException) {
                return (BazaarException)((Object)target);
            }
            t = target;
        }
        return new BazaarException(new BzrTeamStatus(4, -6, t.getMessage() != null ? t.getMessage() : "", t));
    }

    public static BazaarException wrapException(CoreException e) {
        if (e instanceof BazaarException) {
            return (BazaarException)((Object)e);
        }
        return new BazaarException(e);
    }

    public static BazaarException wrapException(BazaarClientException e) {
        String msg = CoreTexts.Unexpected_error;
        if (e.isCommandLine()) {
            msg = CoreTexts.bind((String)CoreTexts.Command_error, (Object)e.getCommand());
        }
        return new BazaarException(4, -6, msg, e);
    }

    public static BazaarException wrapException(BazaarClientException e, IResource resource) {
        String msg = CoreTexts.Unexpected_error;
        if (e.isCommandLine()) {
            msg = CoreTexts.bind((String)CoreTexts.Command_error, (Object)e.getCommand());
        }
        return new BazaarException(new BzrTeamStatus(4, -6, msg, e, resource));
    }

    public static RuntimeException makeUnChecked(CoreException e) {
        return new RuntimeException(e);
    }

    public Throwable getCause() {
        return this.getStatus().getException();
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getMessage() {
        return this.message;
    }
}

